      SUBROUTINE PAGE
C
C     MASTER PAGING ROUTINE FOR NASTRAN.
C
      INTEGER         OTPE,DATE,CRDATE,SYM,TITLEX(18),NAME(2),FCHAR
      CHARACTER       MONTH(12)*3,AHEAD*30,MCHNAM*11,MACHOS*7
      COMMON /CHMACH/ MCHNAM, MACHOS
      COMMON /MACHIN/ MACH(4)
      COMMON /SYSTEM/ SYSBUF,OTPE,MPCN(3),SPCN,METHOD,LOADN,SYM,ST,
     1                IPAGE,LINE,ITLINE,MAXLIN,DATE(3),DUM15(15),IOFP,
     2                X(8),CRDATE(3)
      COMMON /OUTPUT/ TITLE(32),SUBTIT(32),LABEL(32),HEAD1(32),
     1                HEAD2(32),HEAD3(32)
      EQUIVALENCE     (TITLEX(1),TITLE(1))
      DATA    MONTH /'JAN', 'FEB', 'MAR', 'APR', 'MAY', 'JUN', 
     1               'JUL', 'AUG', 'SEP', 'OCT', 'NOV', 'DEC'/
      DATA    NAME  / 4HPAGE, 4H    /
C
      IOUT  = 1
   10 IPAGE = IPAGE  + 1
      ITLINE= ITLINE + LINE
      LINE  = 0
      IF (ITLINE .GT. MAXLIN) GO TO 70
      IN = DATE(1)
C
C   ASSEMBLE PAGE HEADING
C
      AHEAD = ' '
      NCMNAM = INDEX(MCHNAM,' ') - 1
      IF (NCMNAM .LE. -1) NCMNAM = 11
      NCMOS  = INDEX(MACHOS,' ') - 1
      IF (NCMOS .LE. -1) NCMOS = 7
      FCHAR = (18 - NCMNAM - NCMOS)/2 + 1
      WRITE (AHEAD(FCHAR:FCHAR+1),15) CRDATE(3)
   15 FORMAT (A2)
      FCHAR = FCHAR + 3
      AHEAD(FCHAR:30) = MCHNAM(1:NCMNAM) // ' ' // MACHOS(1:NCMOS) //
     1 ' NASTRAN'
C
      WRITE  (OTPE,20) TITLEX, AHEAD, MONTH(IN),DATE(2),DATE(3),IPAGE
   20 FORMAT (1H1,4X,17A4,A2,' /',A30,'/ ',A3,1X,I2,', ',I2, 
     1        ' / PAGE',I6)
      WRITE  (OTPE,30) SUBTIT
   30 FORMAT (5X,31A4,A3)
      WRITE  (OTPE,40) LABEL
   40 FORMAT (1H0,4X,31A4,A3)
      LINE = LINE + 4
      IF (IOUT .EQ.0) GO TO 60
      WRITE (OTPE,40) (HEAD1(I),I=1,32)
      WRITE (OTPE,30) (HEAD2(I),I=1,32)
      WRITE (OTPE,30) (HEAD3(I),I=1,32)
      LINE = LINE + 4
   60 RETURN
C
C     MAX LINES EXCEEDED.  BUMP MAXLINES BY 3000 AND CALL MESAGE
C
   70 MAXLIN = MAXLIN + 3000
      CALL MESAGE (-19,ITLINE,NAME)
      GO TO 60
C
C
      ENTRY PAGE1
C     ===========
C
      IOUT = 0
      GO TO 10
      END
