% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_gmm.R
\name{mtest}
\alias{mtest}
\alias{mtest.pgmm}
\title{Arellano--Bond Test of Serial Correlation}
\usage{
mtest(object, ...)

\method{mtest}{pgmm}(object, order = 1L, vcov = NULL, ...)
}
\arguments{
\item{object}{an object of class \code{"pgmm"},}

\item{\dots}{further arguments (currently unused).}

\item{order}{integer: the order of the serial correlation,}

\item{vcov}{a matrix of covariance for the coefficients or a function to
compute it,}
}
\value{
An object of class \code{"htest"}.
}
\description{
Test of serial correlation for models estimated by GMM
}
\details{
The Arellano--Bond test is a test of correlation based on the residuals of
the estimation. By default, the computation is done with the standard
covariance matrix of the coefficients.  A robust estimator of this
covariance matrix can be supplied with the \code{vcov} argument.
}
\examples{

data("EmplUK", package = "plm")
ar <- pgmm(log(emp) ~ lag(log(emp), 1:2) + lag(log(wage), 0:1) +
           lag(log(capital), 0:2) + lag(log(output), 0:2) | lag(log(emp), 2:99),
           data = EmplUK, effect = "twoways", model = "twosteps")
mtest(ar, order = 1L)
mtest(ar, order = 2L, vcov = vcovHC)

}
\references{
\insertCite{AREL:BOND:91}{plm}
}
\seealso{
\code{\link[=pgmm]{pgmm()}}
}
\author{
Yves Croissant
}
\keyword{htest}
