% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchDatasets.R
\name{searchDatasets}
\alias{searchDatasets}
\title{Search dataset metadata}
\usage{
searchDatasets(
  query,
  cache = cacheDirectory(),
  overwrite = FALSE,
  latest = TRUE
)
}
\arguments{
\item{query}{String containing a query in a human-readable syntax or a \link{gypsum.search.clause}, see Examples.}

\item{cache, overwrite}{Arguments to pass to \code{\link{fetchMetadataDatabase}}.}

\item{latest}{Whether to only consider the latest version of each dataset.}
}
\value{
A \linkS4class{DataFrame} where each row corresponds to a dataset, containing various columns of metadata.
Some columns may be lists to capture 1:many mappings.
}
\description{
Search for datasets of interest based on matching text in the associated metadata.
}
\details{
The returned DataFrame contains the usual suspects like the title and description for each dataset,
the number of rows and columns, the organisms and genome builds involved,
whether the dataset has any pre-computed reduced dimensions, and so on.
More details can be found in the Bioconductor metadata schema at \url{https://github.com/ArtifactDB/bioconductor-metadata-index}.
}
\examples{
searchDatasets("brain")[,c("name", "title")]
searchDatasets("Neuro\%")[,c("name", "title")]
searchDatasets("taxonomy_id:10090")[,c("name", "title")]
searchDatasets("(genome: GRCm38 AND neuro\%) OR pancrea\%")[,c("name", "title")]

}
\seealso{
\code{\link{surveyDatasets}}, to easily obtain a listing of all available datasets.

\code{\link{translateTextQuery}}, for details on the human-readable query syntax.
}
\author{
Aaron Lun
}
