from pathlib import Path

from ._iconfont import IconFont

FONTS = Path(__file__).parent / "fonts"


class FA6S(IconFont):
    """Font Awesome 6 Free-Solid-900."""

    __font_file__ = str(FONTS / "Font Awesome 6 Free-Solid-900.otf")

    address_book = "\uf2b9"
    address_card = "\uf2bb"
    align_center = "\uf037"
    align_justify = "\uf039"
    align_left = "\uf036"
    align_right = "\uf038"
    anchor = "\uf13d"
    anchor_circle_check = "\ue4aa"
    anchor_circle_exclamation = "\ue4ab"
    anchor_circle_xmark = "\ue4ac"
    anchor_lock = "\ue4ad"
    angle_down = "\uf107"
    angle_left = "\uf104"
    angle_right = "\uf105"
    angle_up = "\uf106"
    angles_down = "\uf103"
    angles_left = "\uf100"
    angles_right = "\uf101"
    angles_up = "\uf102"
    ankh = "\uf644"
    apple_whole = "\uf5d1"
    archway = "\uf557"
    arrow_down = "\uf063"
    arrow_down_1_9 = "\uf162"
    arrow_down_9_1 = "\uf886"
    arrow_down_a_z = "\uf15d"
    arrow_down_long = "\uf175"
    arrow_down_short_wide = "\uf884"
    arrow_down_up_across_line = "\ue4af"
    arrow_down_up_lock = "\ue4b0"
    arrow_down_wide_short = "\uf160"
    arrow_down_z_a = "\uf881"
    arrow_left = "\uf060"
    arrow_left_long = "\uf177"
    arrow_pointer = "\uf245"
    arrow_right = "\uf061"
    arrow_right_arrow_left = "\uf0ec"
    arrow_right_from_bracket = "\uf08b"
    arrow_right_long = "\uf178"
    arrow_right_to_bracket = "\uf090"
    arrow_right_to_city = "\ue4b3"
    arrow_rotate_left = "\uf0e2"
    arrow_rotate_right = "\uf01e"
    arrow_trend_down = "\ue097"
    arrow_trend_up = "\ue098"
    arrow_turn_down = "\uf149"
    arrow_turn_up = "\uf148"
    arrow_up = "\uf062"
    arrow_up_1_9 = "\uf163"
    arrow_up_9_1 = "\uf887"
    arrow_up_a_z = "\uf15e"
    arrow_up_from_bracket = "\ue09a"
    arrow_up_from_ground_water = "\ue4b5"
    arrow_up_from_water_pump = "\ue4b6"
    arrow_up_long = "\uf176"
    arrow_up_right_dots = "\ue4b7"
    arrow_up_right_from_square = "\uf08e"
    arrow_up_short_wide = "\uf885"
    arrow_up_wide_short = "\uf161"
    arrow_up_z_a = "\uf882"
    arrows_down_to_line = "\ue4b8"
    arrows_down_to_people = "\ue4b9"
    arrows_left_right = "\uf07e"
    arrows_left_right_to_line = "\ue4ba"
    arrows_rotate = "\uf021"
    arrows_spin = "\ue4bb"
    arrows_split_up_and_left = "\ue4bc"
    arrows_to_circle = "\ue4bd"
    arrows_to_dot = "\ue4be"
    arrows_to_eye = "\ue4bf"
    arrows_turn_right = "\ue4c0"
    arrows_turn_to_dots = "\ue4c1"
    arrows_up_down = "\uf07d"
    arrows_up_down_left_right = "\uf047"
    arrows_up_to_line = "\ue4c2"
    atom = "\uf5d2"
    audio_description = "\uf29e"
    austral_sign = "\ue0a9"
    award = "\uf559"
    baby = "\uf77c"
    baby_carriage = "\uf77d"
    backward = "\uf04a"
    backward_fast = "\uf049"
    backward_step = "\uf048"
    bacon = "\uf7e5"
    bacteria = "\ue059"
    bacterium = "\ue05a"
    bag_shopping = "\uf290"
    bahai = "\uf666"
    baht_sign = "\ue0ac"
    ban = "\uf05e"
    ban_smoking = "\uf54d"
    bandage = "\uf462"
    bangladeshi_taka_sign = "\ue2e6"
    barcode = "\uf02a"
    bars = "\uf0c9"
    bars_progress = "\uf828"
    bars_staggered = "\uf550"
    baseball = "\uf433"
    baseball_bat_ball = "\uf432"
    basket_shopping = "\uf291"
    basketball = "\uf434"
    bath = "\uf2cd"
    battery_empty = "\uf244"
    battery_full = "\uf240"
    battery_half = "\uf242"
    battery_quarter = "\uf243"
    battery_three_quarters = "\uf241"
    bed = "\uf236"
    bed_pulse = "\uf487"
    beer_mug_empty = "\uf0fc"
    bell = "\uf0f3"
    bell_concierge = "\uf562"
    bell_slash = "\uf1f6"
    bezier_curve = "\uf55b"
    bicycle = "\uf206"
    binoculars = "\uf1e5"
    biohazard = "\uf780"
    bitcoin_sign = "\ue0b4"
    blender = "\uf517"
    blender_phone = "\uf6b6"
    blog = "\uf781"
    bold = "\uf032"
    bolt = "\uf0e7"
    bolt_lightning = "\ue0b7"
    bomb = "\uf1e2"
    bone = "\uf5d7"
    bong = "\uf55c"
    book = "\uf02d"
    book_atlas = "\uf558"
    book_bible = "\uf647"
    book_bookmark = "\ue0bb"
    book_journal_whills = "\uf66a"
    book_medical = "\uf7e6"
    book_open = "\uf518"
    book_open_reader = "\uf5da"
    book_quran = "\uf687"
    book_skull = "\uf6b7"
    book_tanakh = "\uf827"
    bookmark = "\uf02e"
    border_all = "\uf84c"
    border_none = "\uf850"
    border_top_left = "\uf853"
    bore_hole = "\ue4c3"
    bottle_droplet = "\ue4c4"
    bottle_water = "\ue4c5"
    bowl_food = "\ue4c6"
    bowl_rice = "\ue2eb"
    bowling_ball = "\uf436"
    box = "\uf466"
    box_archive = "\uf187"
    box_open = "\uf49e"
    box_tissue = "\ue05b"
    boxes_packing = "\ue4c7"
    boxes_stacked = "\uf468"
    braille = "\uf2a1"
    brain = "\uf5dc"
    brazilian_real_sign = "\ue46c"
    bread_slice = "\uf7ec"
    bridge = "\ue4c8"
    bridge_circle_check = "\ue4c9"
    bridge_circle_exclamation = "\ue4ca"
    bridge_circle_xmark = "\ue4cb"
    bridge_lock = "\ue4cc"
    bridge_water = "\ue4ce"
    briefcase = "\uf0b1"
    briefcase_medical = "\uf469"
    broom = "\uf51a"
    broom_ball = "\uf458"
    brush = "\uf55d"
    bucket = "\ue4cf"
    bug = "\uf188"
    bug_slash = "\ue490"
    bugs = "\ue4d0"
    building = "\uf1ad"
    building_circle_arrow_right = "\ue4d1"
    building_circle_check = "\ue4d2"
    building_circle_exclamation = "\ue4d3"
    building_circle_xmark = "\ue4d4"
    building_columns = "\uf19c"
    building_flag = "\ue4d5"
    building_lock = "\ue4d6"
    building_ngo = "\ue4d7"
    building_shield = "\ue4d8"
    building_un = "\ue4d9"
    building_user = "\ue4da"
    building_wheat = "\ue4db"
    bullhorn = "\uf0a1"
    bullseye = "\uf140"
    burger = "\uf805"
    burst = "\ue4dc"
    bus = "\uf207"
    bus_simple = "\uf55e"
    business_time = "\uf64a"
    cable_car = "\uf7da"
    cake_candles = "\uf1fd"
    calculator = "\uf1ec"
    calendar = "\uf133"
    calendar_check = "\uf274"
    calendar_day = "\uf783"
    calendar_days = "\uf073"
    calendar_minus = "\uf272"
    calendar_plus = "\uf271"
    calendar_week = "\uf784"
    calendar_xmark = "\uf273"
    camera = "\uf030"
    camera_retro = "\uf083"
    camera_rotate = "\ue0d8"
    campground = "\uf6bb"
    candy_cane = "\uf786"
    cannabis = "\uf55f"
    capsules = "\uf46b"
    car = "\uf1b9"
    car_battery = "\uf5df"
    car_burst = "\uf5e1"
    car_on = "\ue4dd"
    car_rear = "\uf5de"
    car_side = "\uf5e4"
    car_tunnel = "\ue4de"
    caravan = "\uf8ff"
    caret_down = "\uf0d7"
    caret_left = "\uf0d9"
    caret_right = "\uf0da"
    caret_up = "\uf0d8"
    carrot = "\uf787"
    cart_arrow_down = "\uf218"
    cart_flatbed = "\uf474"
    cart_flatbed_suitcase = "\uf59d"
    cart_plus = "\uf217"
    cart_shopping = "\uf07a"
    cash_register = "\uf788"
    cat = "\uf6be"
    cedi_sign = "\ue0df"
    cent_sign = "\ue3f5"
    certificate = "\uf0a3"
    chair = "\uf6c0"
    chalkboard = "\uf51b"
    chalkboard_user = "\uf51c"
    champagne_glasses = "\uf79f"
    charging_station = "\uf5e7"
    chart_area = "\uf1fe"
    chart_bar = "\uf080"
    chart_column = "\ue0e3"
    chart_gantt = "\ue0e4"
    chart_line = "\uf201"
    chart_pie = "\uf200"
    chart_simple = "\ue473"
    check = "\uf00c"
    check_double = "\uf560"
    check_to_slot = "\uf772"
    cheese = "\uf7ef"
    chess = "\uf439"
    chess_bishop = "\uf43a"
    chess_board = "\uf43c"
    chess_king = "\uf43f"
    chess_knight = "\uf441"
    chess_pawn = "\uf443"
    chess_queen = "\uf445"
    chess_rook = "\uf447"
    chevron_down = "\uf078"
    chevron_left = "\uf053"
    chevron_right = "\uf054"
    chevron_up = "\uf077"
    child = "\uf1ae"
    child_combatant = "\ue4e0"
    child_dress = "\ue59c"
    child_reaching = "\ue59d"
    children = "\ue4e1"
    church = "\uf51d"
    circle = "\uf111"
    circle_arrow_down = "\uf0ab"
    circle_arrow_left = "\uf0a8"
    circle_arrow_right = "\uf0a9"
    circle_arrow_up = "\uf0aa"
    circle_check = "\uf058"
    circle_chevron_down = "\uf13a"
    circle_chevron_left = "\uf137"
    circle_chevron_right = "\uf138"
    circle_chevron_up = "\uf139"
    circle_dollar_to_slot = "\uf4b9"
    circle_dot = "\uf192"
    circle_down = "\uf358"
    circle_exclamation = "\uf06a"
    circle_h = "\uf47e"
    circle_half_stroke = "\uf042"
    circle_info = "\uf05a"
    circle_left = "\uf359"
    circle_minus = "\uf056"
    circle_nodes = "\ue4e2"
    circle_notch = "\uf1ce"
    circle_pause = "\uf28b"
    circle_play = "\uf144"
    circle_plus = "\uf055"
    circle_question = "\uf059"
    circle_radiation = "\uf7ba"
    circle_right = "\uf35a"
    circle_stop = "\uf28d"
    circle_up = "\uf35b"
    circle_user = "\uf2bd"
    circle_xmark = "\uf057"
    city = "\uf64f"
    clapperboard = "\ue131"
    clipboard = "\uf328"
    clipboard_check = "\uf46c"
    clipboard_list = "\uf46d"
    clipboard_question = "\ue4e3"
    clipboard_user = "\uf7f3"
    clock = "\uf017"
    clock_rotate_left = "\uf1da"
    clone = "\uf24d"
    closed_captioning = "\uf20a"
    cloud = "\uf0c2"
    cloud_arrow_down = "\uf0ed"
    cloud_arrow_up = "\uf0ee"
    cloud_bolt = "\uf76c"
    cloud_meatball = "\uf73b"
    cloud_moon = "\uf6c3"
    cloud_moon_rain = "\uf73c"
    cloud_rain = "\uf73d"
    cloud_showers_heavy = "\uf740"
    cloud_showers_water = "\ue4e4"
    cloud_sun = "\uf6c4"
    cloud_sun_rain = "\uf743"
    clover = "\ue139"
    code = "\uf121"
    code_branch = "\uf126"
    code_commit = "\uf386"
    code_compare = "\ue13a"
    code_fork = "\ue13b"
    code_merge = "\uf387"
    code_pull_request = "\ue13c"
    coins = "\uf51e"
    colon_sign = "\ue140"
    comment = "\uf075"
    comment_dollar = "\uf651"
    comment_dots = "\uf4ad"
    comment_medical = "\uf7f5"
    comment_slash = "\uf4b3"
    comment_sms = "\uf7cd"
    comments = "\uf086"
    comments_dollar = "\uf653"
    compact_disc = "\uf51f"
    compass = "\uf14e"
    compass_drafting = "\uf568"
    compress = "\uf066"
    computer = "\ue4e5"
    computer_mouse = "\uf8cc"
    cookie = "\uf563"
    cookie_bite = "\uf564"
    copy = "\uf0c5"
    copyright = "\uf1f9"
    couch = "\uf4b8"
    cow = "\uf6c8"
    credit_card = "\uf09d"
    crop = "\uf125"
    crop_simple = "\uf565"
    cross = "\uf654"
    crosshairs = "\uf05b"
    crow = "\uf520"
    crown = "\uf521"
    crutch = "\uf7f7"
    cruzeiro_sign = "\ue152"
    cube = "\uf1b2"
    cubes = "\uf1b3"
    cubes_stacked = "\ue4e6"
    database = "\uf1c0"
    delete_left = "\uf55a"
    democrat = "\uf747"
    desktop = "\uf390"
    dharmachakra = "\uf655"
    diagram_next = "\ue476"
    diagram_predecessor = "\ue477"
    diagram_project = "\uf542"
    diagram_successor = "\ue47a"
    diamond = "\uf219"
    diamond_turn_right = "\uf5eb"
    dice = "\uf522"
    dice_d20 = "\uf6cf"
    dice_d6 = "\uf6d1"
    dice_five = "\uf523"
    dice_four = "\uf524"
    dice_one = "\uf525"
    dice_six = "\uf526"
    dice_three = "\uf527"
    dice_two = "\uf528"
    disease = "\uf7fa"
    display = "\ue163"
    divide = "\uf529"
    dna = "\uf471"
    dog = "\uf6d3"
    dolly = "\uf472"
    dong_sign = "\ue169"
    door_closed = "\uf52a"
    door_open = "\uf52b"
    dove = "\uf4ba"
    down_left_and_up_right_to_center = "\uf422"
    down_long = "\uf309"
    download = "\uf019"
    dragon = "\uf6d5"
    draw_polygon = "\uf5ee"
    droplet = "\uf043"
    droplet_slash = "\uf5c7"
    drum = "\uf569"
    drum_steelpan = "\uf56a"
    drumstick_bite = "\uf6d7"
    dumbbell = "\uf44b"
    dumpster = "\uf793"
    dumpster_fire = "\uf794"
    dungeon = "\uf6d9"
    ear_deaf = "\uf2a4"
    ear_listen = "\uf2a2"
    earth_africa = "\uf57c"
    earth_americas = "\uf57d"
    earth_asia = "\uf57e"
    earth_europe = "\uf7a2"
    earth_oceania = "\ue47b"
    egg = "\uf7fb"
    eject = "\uf052"
    elevator = "\ue16d"
    ellipsis = "\uf141"
    ellipsis_vertical = "\uf142"
    envelope = "\uf0e0"
    envelope_circle_check = "\ue4e8"
    envelope_open = "\uf2b6"
    envelope_open_text = "\uf658"
    envelopes_bulk = "\uf674"
    eraser = "\uf12d"
    ethernet = "\uf796"
    euro_sign = "\uf153"
    expand = "\uf065"
    explosion = "\ue4e9"
    eye = "\uf06e"
    eye_dropper = "\uf1fb"
    eye_low_vision = "\uf2a8"
    eye_slash = "\uf070"
    face_angry = "\uf556"
    face_dizzy = "\uf567"
    face_flushed = "\uf579"
    face_frown = "\uf119"
    face_frown_open = "\uf57a"
    face_grimace = "\uf57f"
    face_grin = "\uf580"
    face_grin_beam = "\uf582"
    face_grin_beam_sweat = "\uf583"
    face_grin_hearts = "\uf584"
    face_grin_squint = "\uf585"
    face_grin_squint_tears = "\uf586"
    face_grin_stars = "\uf587"
    face_grin_tears = "\uf588"
    face_grin_tongue = "\uf589"
    face_grin_tongue_squint = "\uf58a"
    face_grin_tongue_wink = "\uf58b"
    face_grin_wide = "\uf581"
    face_grin_wink = "\uf58c"
    face_kiss = "\uf596"
    face_kiss_beam = "\uf597"
    face_kiss_wink_heart = "\uf598"
    face_laugh = "\uf599"
    face_laugh_beam = "\uf59a"
    face_laugh_squint = "\uf59b"
    face_laugh_wink = "\uf59c"
    face_meh = "\uf11a"
    face_meh_blank = "\uf5a4"
    face_rolling_eyes = "\uf5a5"
    face_sad_cry = "\uf5b3"
    face_sad_tear = "\uf5b4"
    face_smile = "\uf118"
    face_smile_beam = "\uf5b8"
    face_smile_wink = "\uf4da"
    face_surprise = "\uf5c2"
    face_tired = "\uf5c8"
    fan = "\uf863"
    faucet = "\ue005"
    faucet_drip = "\ue006"
    fax = "\uf1ac"
    feather = "\uf52d"
    feather_pointed = "\uf56b"
    ferry = "\ue4ea"
    file = "\uf15b"
    file_arrow_down = "\uf56d"
    file_arrow_up = "\uf574"
    file_audio = "\uf1c7"
    file_circle_check = "\ue5a0"
    file_circle_exclamation = "\ue4eb"
    file_circle_minus = "\ue4ed"
    file_circle_plus = "\ue494"
    file_circle_question = "\ue4ef"
    file_circle_xmark = "\ue5a1"
    file_code = "\uf1c9"
    file_contract = "\uf56c"
    file_csv = "\uf6dd"
    file_excel = "\uf1c3"
    file_export = "\uf56e"
    file_image = "\uf1c5"
    file_import = "\uf56f"
    file_invoice = "\uf570"
    file_invoice_dollar = "\uf571"
    file_lines = "\uf15c"
    file_medical = "\uf477"
    file_pdf = "\uf1c1"
    file_pen = "\uf31c"
    file_powerpoint = "\uf1c4"
    file_prescription = "\uf572"
    file_shield = "\ue4f0"
    file_signature = "\uf573"
    file_video = "\uf1c8"
    file_waveform = "\uf478"
    file_word = "\uf1c2"
    file_zipper = "\uf1c6"
    fill = "\uf575"
    fill_drip = "\uf576"
    film = "\uf008"
    filter = "\uf0b0"
    filter_circle_dollar = "\uf662"
    filter_circle_xmark = "\ue17b"
    fingerprint = "\uf577"
    fire = "\uf06d"
    fire_burner = "\ue4f1"
    fire_extinguisher = "\uf134"
    fire_flame_curved = "\uf7e4"
    fire_flame_simple = "\uf46a"
    fish = "\uf578"
    fish_fins = "\ue4f2"
    flag = "\uf024"
    flag_checkered = "\uf11e"
    flag_usa = "\uf74d"
    flask = "\uf0c3"
    flask_vial = "\ue4f3"
    floppy_disk = "\uf0c7"
    florin_sign = "\ue184"
    folder = "\uf07b"
    folder_closed = "\ue185"
    folder_minus = "\uf65d"
    folder_open = "\uf07c"
    folder_plus = "\uf65e"
    folder_tree = "\uf802"
    font = "\uf031"
    font_awesome = "\uf2b4"
    football = "\uf44e"
    forward = "\uf04e"
    forward_fast = "\uf050"
    forward_step = "\uf051"
    franc_sign = "\ue18f"
    frog = "\uf52e"
    futbol = "\uf1e3"
    gamepad = "\uf11b"
    gas_pump = "\uf52f"
    gauge = "\uf624"
    gauge_high = "\uf625"
    gauge_simple = "\uf629"
    gauge_simple_high = "\uf62a"
    gavel = "\uf0e3"
    gear = "\uf013"
    gears = "\uf085"
    gem = "\uf3a5"
    genderless = "\uf22d"
    ghost = "\uf6e2"
    gift = "\uf06b"
    gifts = "\uf79c"
    glass_water = "\ue4f4"
    glass_water_droplet = "\ue4f5"
    glasses = "\uf530"
    globe = "\uf0ac"
    golf_ball_tee = "\uf450"
    gopuram = "\uf664"
    graduation_cap = "\uf19d"
    greater_than_equal = "\uf532"
    grip = "\uf58d"
    grip_lines = "\uf7a4"
    grip_lines_vertical = "\uf7a5"
    grip_vertical = "\uf58e"
    group_arrows_rotate = "\ue4f6"
    guarani_sign = "\ue19a"
    guitar = "\uf7a6"
    gun = "\ue19b"
    hammer = "\uf6e3"
    hamsa = "\uf665"
    hand = "\uf256"
    hand_back_fist = "\uf255"
    hand_dots = "\uf461"
    hand_fist = "\uf6de"
    hand_holding = "\uf4bd"
    hand_holding_dollar = "\uf4c0"
    hand_holding_droplet = "\uf4c1"
    hand_holding_hand = "\ue4f7"
    hand_holding_heart = "\uf4be"
    hand_holding_medical = "\ue05c"
    hand_lizard = "\uf258"
    hand_middle_finger = "\uf806"
    hand_peace = "\uf25b"
    hand_point_down = "\uf0a7"
    hand_point_left = "\uf0a5"
    hand_point_right = "\uf0a4"
    hand_point_up = "\uf0a6"
    hand_pointer = "\uf25a"
    hand_scissors = "\uf257"
    hand_sparkles = "\ue05d"
    hand_spock = "\uf259"
    handcuffs = "\ue4f8"
    hands = "\uf2a7"
    hands_asl_interpreting = "\uf2a3"
    hands_bound = "\ue4f9"
    hands_bubbles = "\ue05e"
    hands_clapping = "\ue1a8"
    hands_holding = "\uf4c2"
    hands_holding_child = "\ue4fa"
    hands_holding_circle = "\ue4fb"
    hands_praying = "\uf684"
    handshake = "\uf2b5"
    handshake_angle = "\uf4c4"
    handshake_simple = "\uf4c6"
    handshake_simple_slash = "\ue05f"
    handshake_slash = "\ue060"
    hanukiah = "\uf6e6"
    hard_drive = "\uf0a0"
    hat_cowboy = "\uf8c0"
    hat_cowboy_side = "\uf8c1"
    hat_wizard = "\uf6e8"
    head_side_cough = "\ue061"
    head_side_cough_slash = "\ue062"
    head_side_mask = "\ue063"
    head_side_virus = "\ue064"
    heading = "\uf1dc"
    headphones = "\uf025"
    headphones_simple = "\uf58f"
    headset = "\uf590"
    heart = "\uf004"
    heart_circle_bolt = "\ue4fc"
    heart_circle_check = "\ue4fd"
    heart_circle_exclamation = "\ue4fe"
    heart_circle_minus = "\ue4ff"
    heart_circle_plus = "\ue500"
    heart_circle_xmark = "\ue501"
    heart_crack = "\uf7a9"
    heart_pulse = "\uf21e"
    helicopter = "\uf533"
    helicopter_symbol = "\ue502"
    helmet_safety = "\uf807"
    helmet_un = "\ue503"
    highlighter = "\uf591"
    hill_avalanche = "\ue507"
    hill_rockslide = "\ue508"
    hippo = "\uf6ed"
    hockey_puck = "\uf453"
    holly_berry = "\uf7aa"
    horse = "\uf6f0"
    horse_head = "\uf7ab"
    hospital = "\uf0f8"
    hospital_user = "\uf80d"
    hot_tub_person = "\uf593"
    hotdog = "\uf80f"
    hotel = "\uf594"
    hourglass = "\uf254"
    hourglass_end = "\uf253"
    hourglass_half = "\uf252"
    hourglass_start = "\uf251"
    house = "\uf015"
    house_chimney = "\ue3af"
    house_chimney_crack = "\uf6f1"
    house_chimney_medical = "\uf7f2"
    house_chimney_user = "\ue065"
    house_chimney_window = "\ue00d"
    house_circle_check = "\ue509"
    house_circle_exclamation = "\ue50a"
    house_circle_xmark = "\ue50b"
    house_crack = "\ue3b1"
    house_fire = "\ue50c"
    house_flag = "\ue50d"
    house_flood_water = "\ue50e"
    house_flood_water_circle_arrow_right = "\ue50f"
    house_laptop = "\ue066"
    house_lock = "\ue510"
    house_medical = "\ue3b2"
    house_medical_circle_check = "\ue511"
    house_medical_circle_exclamation = "\ue512"
    house_medical_circle_xmark = "\ue513"
    house_medical_flag = "\ue514"
    house_signal = "\ue012"
    house_tsunami = "\ue515"
    house_user = "\ue1b0"
    hryvnia_sign = "\uf6f2"
    hurricane = "\uf751"
    i_cursor = "\uf246"
    ice_cream = "\uf810"
    icicles = "\uf7ad"
    icons = "\uf86d"
    id_badge = "\uf2c1"
    id_card = "\uf2c2"
    id_card_clip = "\uf47f"
    igloo = "\uf7ae"
    image = "\uf03e"
    image_portrait = "\uf3e0"
    images = "\uf302"
    inbox = "\uf01c"
    indent = "\uf03c"
    indian_rupee_sign = "\ue1bc"
    industry = "\uf275"
    infinity = "\uf534"
    info = "\uf129"
    italic = "\uf033"
    jar = "\ue516"
    jar_wheat = "\ue517"
    jedi = "\uf669"
    jet_fighter = "\uf0fb"
    jet_fighter_up = "\ue518"
    joint = "\uf595"
    jug_detergent = "\ue519"
    kaaba = "\uf66b"
    key = "\uf084"
    keyboard = "\uf11c"
    khanda = "\uf66d"
    kip_sign = "\ue1c4"
    kit_medical = "\uf479"
    kitchen_set = "\ue51a"
    kiwi_bird = "\uf535"
    land_mine_on = "\ue51b"
    landmark = "\uf66f"
    landmark_dome = "\uf752"
    landmark_flag = "\ue51c"
    language = "\uf1ab"
    laptop = "\uf109"
    laptop_code = "\uf5fc"
    laptop_file = "\ue51d"
    laptop_medical = "\uf812"
    lari_sign = "\ue1c8"
    layer_group = "\uf5fd"
    leaf = "\uf06c"
    left_long = "\uf30a"
    left_right = "\uf337"
    lemon = "\uf094"
    less_than_equal = "\uf537"
    life_ring = "\uf1cd"
    lightbulb = "\uf0eb"
    lines_leaning = "\ue51e"
    link = "\uf0c1"
    link_slash = "\uf127"
    lira_sign = "\uf195"
    list = "\uf03a"
    list_check = "\uf0ae"
    list_ol = "\uf0cb"
    list_ul = "\uf0ca"
    litecoin_sign = "\ue1d3"
    location_arrow = "\uf124"
    location_crosshairs = "\uf601"
    location_dot = "\uf3c5"
    location_pin = "\uf041"
    location_pin_lock = "\ue51f"
    lock = "\uf023"
    lock_open = "\uf3c1"
    locust = "\ue520"
    lungs = "\uf604"
    lungs_virus = "\ue067"
    magnet = "\uf076"
    magnifying_glass = "\uf002"
    magnifying_glass_arrow_right = "\ue521"
    magnifying_glass_chart = "\ue522"
    magnifying_glass_dollar = "\uf688"
    magnifying_glass_location = "\uf689"
    magnifying_glass_minus = "\uf010"
    magnifying_glass_plus = "\uf00e"
    manat_sign = "\ue1d5"
    map = "\uf279"
    map_location = "\uf59f"
    map_location_dot = "\uf5a0"
    map_pin = "\uf276"
    marker = "\uf5a1"
    mars = "\uf222"
    mars_and_venus = "\uf224"
    mars_and_venus_burst = "\ue523"
    mars_double = "\uf227"
    mars_stroke = "\uf229"
    mars_stroke_right = "\uf22b"
    mars_stroke_up = "\uf22a"
    martini_glass = "\uf57b"
    martini_glass_citrus = "\uf561"
    martini_glass_empty = "\uf000"
    mask = "\uf6fa"
    mask_face = "\ue1d7"
    mask_ventilator = "\ue524"
    masks_theater = "\uf630"
    mattress_pillow = "\ue525"
    maximize = "\uf31e"
    medal = "\uf5a2"
    memory = "\uf538"
    menorah = "\uf676"
    mercury = "\uf223"
    message = "\uf27a"
    meteor = "\uf753"
    microchip = "\uf2db"
    microphone = "\uf130"
    microphone_lines = "\uf3c9"
    microphone_lines_slash = "\uf539"
    microphone_slash = "\uf131"
    microscope = "\uf610"
    mill_sign = "\ue1ed"
    minimize = "\uf78c"
    minus = "\uf068"
    mitten = "\uf7b5"
    mobile = "\uf3ce"
    mobile_button = "\uf10b"
    mobile_retro = "\ue527"
    mobile_screen = "\uf3cf"
    mobile_screen_button = "\uf3cd"
    money_bill = "\uf0d6"
    money_bill_1 = "\uf3d1"
    money_bill_1_wave = "\uf53b"
    money_bill_transfer = "\ue528"
    money_bill_trend_up = "\ue529"
    money_bill_wave = "\uf53a"
    money_bill_wheat = "\ue52a"
    money_bills = "\ue1f3"
    money_check = "\uf53c"
    money_check_dollar = "\uf53d"
    monument = "\uf5a6"
    moon = "\uf186"
    mortar_pestle = "\uf5a7"
    mosque = "\uf678"
    mosquito = "\ue52b"
    mosquito_net = "\ue52c"
    motorcycle = "\uf21c"
    mound = "\ue52d"
    mountain = "\uf6fc"
    mountain_city = "\ue52e"
    mountain_sun = "\ue52f"
    mug_hot = "\uf7b6"
    mug_saucer = "\uf0f4"
    music = "\uf001"
    naira_sign = "\ue1f6"
    network_wired = "\uf6ff"
    neuter = "\uf22c"
    newspaper = "\uf1ea"
    not_equal = "\uf53e"
    notdef = "\ue1fe"
    note_sticky = "\uf249"
    notes_medical = "\uf481"
    object_group = "\uf247"
    object_ungroup = "\uf248"
    oil_can = "\uf613"
    oil_well = "\ue532"
    om = "\uf679"
    otter = "\uf700"
    outdent = "\uf03b"
    pager = "\uf815"
    paint_roller = "\uf5aa"
    paintbrush = "\uf1fc"
    palette = "\uf53f"
    pallet = "\uf482"
    panorama = "\ue209"
    paper_plane = "\uf1d8"
    paperclip = "\uf0c6"
    parachute_box = "\uf4cd"
    paragraph = "\uf1dd"
    passport = "\uf5ab"
    paste = "\uf0ea"
    pause = "\uf04c"
    paw = "\uf1b0"
    peace = "\uf67c"
    pen = "\uf304"
    pen_clip = "\uf305"
    pen_fancy = "\uf5ac"
    pen_nib = "\uf5ad"
    pen_ruler = "\uf5ae"
    pen_to_square = "\uf044"
    pencil = "\uf303"
    people_arrows = "\ue068"
    people_carry_box = "\uf4ce"
    people_group = "\ue533"
    people_line = "\ue534"
    people_pulling = "\ue535"
    people_robbery = "\ue536"
    people_roof = "\ue537"
    pepper_hot = "\uf816"
    person = "\uf183"
    person_arrow_down_to_line = "\ue538"
    person_arrow_up_from_line = "\ue539"
    person_biking = "\uf84a"
    person_booth = "\uf756"
    person_breastfeeding = "\ue53a"
    person_burst = "\ue53b"
    person_cane = "\ue53c"
    person_chalkboard = "\ue53d"
    person_circle_check = "\ue53e"
    person_circle_exclamation = "\ue53f"
    person_circle_minus = "\ue540"
    person_circle_plus = "\ue541"
    person_circle_question = "\ue542"
    person_circle_xmark = "\ue543"
    person_digging = "\uf85e"
    person_dots_from_line = "\uf470"
    person_dress = "\uf182"
    person_dress_burst = "\ue544"
    person_drowning = "\ue545"
    person_falling = "\ue546"
    person_falling_burst = "\ue547"
    person_half_dress = "\ue548"
    person_harassing = "\ue549"
    person_hiking = "\uf6ec"
    person_military_pointing = "\ue54a"
    person_military_rifle = "\ue54b"
    person_military_to_person = "\ue54c"
    person_praying = "\uf683"
    person_pregnant = "\ue31e"
    person_rays = "\ue54d"
    person_rifle = "\ue54e"
    person_running = "\uf70c"
    person_shelter = "\ue54f"
    person_skating = "\uf7c5"
    person_skiing = "\uf7c9"
    person_skiing_nordic = "\uf7ca"
    person_snowboarding = "\uf7ce"
    person_swimming = "\uf5c4"
    person_through_window = "\ue5a9"
    person_walking = "\uf554"
    person_walking_arrow_loop_left = "\ue551"
    person_walking_arrow_right = "\ue552"
    person_walking_dashed_line_arrow_right = "\ue553"
    person_walking_luggage = "\ue554"
    person_walking_with_cane = "\uf29d"
    peseta_sign = "\ue221"
    peso_sign = "\ue222"
    phone = "\uf095"
    phone_flip = "\uf879"
    phone_slash = "\uf3dd"
    phone_volume = "\uf2a0"
    photo_film = "\uf87c"
    piggy_bank = "\uf4d3"
    pills = "\uf484"
    pizza_slice = "\uf818"
    place_of_worship = "\uf67f"
    plane = "\uf072"
    plane_arrival = "\uf5af"
    plane_circle_check = "\ue555"
    plane_circle_exclamation = "\ue556"
    plane_circle_xmark = "\ue557"
    plane_departure = "\uf5b0"
    plane_lock = "\ue558"
    plane_slash = "\ue069"
    plane_up = "\ue22d"
    plant_wilt = "\ue5aa"
    plate_wheat = "\ue55a"
    play = "\uf04b"
    plug = "\uf1e6"
    plug_circle_bolt = "\ue55b"
    plug_circle_check = "\ue55c"
    plug_circle_exclamation = "\ue55d"
    plug_circle_minus = "\ue55e"
    plug_circle_plus = "\ue55f"
    plug_circle_xmark = "\ue560"
    plus_minus = "\ue43c"
    podcast = "\uf2ce"
    poo = "\uf2fe"
    poo_storm = "\uf75a"
    poop = "\uf619"
    power_off = "\uf011"
    prescription = "\uf5b1"
    prescription_bottle = "\uf485"
    prescription_bottle_medical = "\uf486"
    print = "\uf02f"
    pump_medical = "\ue06a"
    pump_soap = "\ue06b"
    puzzle_piece = "\uf12e"
    qrcode = "\uf029"
    quote_left = "\uf10d"
    quote_right = "\uf10e"
    radiation = "\uf7b9"
    radio = "\uf8d7"
    rainbow = "\uf75b"
    ranking_star = "\ue561"
    receipt = "\uf543"
    record_vinyl = "\uf8d9"
    rectangle_ad = "\uf641"
    rectangle_list = "\uf022"
    rectangle_xmark = "\uf410"
    recycle = "\uf1b8"
    registered = "\uf25d"
    repeat = "\uf363"
    reply = "\uf3e5"
    reply_all = "\uf122"
    republican = "\uf75e"
    restroom = "\uf7bd"
    retweet = "\uf079"
    ribbon = "\uf4d6"
    right_from_bracket = "\uf2f5"
    right_left = "\uf362"
    right_long = "\uf30b"
    right_to_bracket = "\uf2f6"
    ring = "\uf70b"
    road = "\uf018"
    road_barrier = "\ue562"
    road_bridge = "\ue563"
    road_circle_check = "\ue564"
    road_circle_exclamation = "\ue565"
    road_circle_xmark = "\ue566"
    road_lock = "\ue567"
    road_spikes = "\ue568"
    robot = "\uf544"
    rocket = "\uf135"
    rotate = "\uf2f1"
    rotate_left = "\uf2ea"
    rotate_right = "\uf2f9"
    route = "\uf4d7"
    rss = "\uf09e"
    ruble_sign = "\uf158"
    rug = "\ue569"
    ruler = "\uf545"
    ruler_combined = "\uf546"
    ruler_horizontal = "\uf547"
    ruler_vertical = "\uf548"
    rupee_sign = "\uf156"
    rupiah_sign = "\ue23d"
    sack_dollar = "\uf81d"
    sack_xmark = "\ue56a"
    sailboat = "\ue445"
    satellite = "\uf7bf"
    satellite_dish = "\uf7c0"
    scale_balanced = "\uf24e"
    scale_unbalanced = "\uf515"
    scale_unbalanced_flip = "\uf516"
    school = "\uf549"
    school_circle_check = "\ue56b"
    school_circle_exclamation = "\ue56c"
    school_circle_xmark = "\ue56d"
    school_flag = "\ue56e"
    school_lock = "\ue56f"
    scissors = "\uf0c4"
    screwdriver = "\uf54a"
    screwdriver_wrench = "\uf7d9"
    scroll = "\uf70e"
    scroll_torah = "\uf6a0"
    sd_card = "\uf7c2"
    section = "\ue447"
    seedling = "\uf4d8"
    server = "\uf233"
    shapes = "\uf61f"
    share = "\uf064"
    share_from_square = "\uf14d"
    share_nodes = "\uf1e0"
    sheet_plastic = "\ue571"
    shekel_sign = "\uf20b"
    shield = "\uf132"
    shield_cat = "\ue572"
    shield_dog = "\ue573"
    shield_halved = "\uf3ed"
    shield_heart = "\ue574"
    shield_virus = "\ue06c"
    ship = "\uf21a"
    shirt = "\uf553"
    shoe_prints = "\uf54b"
    shop = "\uf54f"
    shop_lock = "\ue4a5"
    shop_slash = "\ue070"
    shower = "\uf2cc"
    shrimp = "\ue448"
    shuffle = "\uf074"
    shuttle_space = "\uf197"
    sign_hanging = "\uf4d9"
    signal = "\uf012"
    signature = "\uf5b7"
    signs_post = "\uf277"
    sim_card = "\uf7c4"
    sink = "\ue06d"
    sitemap = "\uf0e8"
    skull = "\uf54c"
    skull_crossbones = "\uf714"
    slash = "\uf715"
    sleigh = "\uf7cc"
    sliders = "\uf1de"
    smog = "\uf75f"
    smoking = "\uf48d"
    snowflake = "\uf2dc"
    snowman = "\uf7d0"
    snowplow = "\uf7d2"
    soap = "\ue06e"
    socks = "\uf696"
    solar_panel = "\uf5ba"
    sort = "\uf0dc"
    sort_down = "\uf0dd"
    sort_up = "\uf0de"
    spa = "\uf5bb"
    spaghetti_monster_flying = "\uf67b"
    spell_check = "\uf891"
    spider = "\uf717"
    spinner = "\uf110"
    splotch = "\uf5bc"
    spoon = "\uf2e5"
    spray_can = "\uf5bd"
    spray_can_sparkles = "\uf5d0"
    square = "\uf0c8"
    square_arrow_up_right = "\uf14c"
    square_caret_down = "\uf150"
    square_caret_left = "\uf191"
    square_caret_right = "\uf152"
    square_caret_up = "\uf151"
    square_check = "\uf14a"
    square_envelope = "\uf199"
    square_full = "\uf45c"
    square_h = "\uf0fd"
    square_minus = "\uf146"
    square_nfi = "\ue576"
    square_parking = "\uf540"
    square_pen = "\uf14b"
    square_person_confined = "\ue577"
    square_phone = "\uf098"
    square_phone_flip = "\uf87b"
    square_plus = "\uf0fe"
    square_poll_horizontal = "\uf682"
    square_poll_vertical = "\uf681"
    square_root_variable = "\uf698"
    square_rss = "\uf143"
    square_share_nodes = "\uf1e1"
    square_up_right = "\uf360"
    square_virus = "\ue578"
    square_xmark = "\uf2d3"
    staff_snake = "\ue579"
    stairs = "\ue289"
    stamp = "\uf5bf"
    stapler = "\ue5af"
    star = "\uf005"
    star_and_crescent = "\uf699"
    star_half = "\uf089"
    star_half_stroke = "\uf5c0"
    star_of_david = "\uf69a"
    star_of_life = "\uf621"
    sterling_sign = "\uf154"
    stethoscope = "\uf0f1"
    stop = "\uf04d"
    stopwatch = "\uf2f2"
    stopwatch_20 = "\ue06f"
    store = "\uf54e"
    store_slash = "\ue071"
    street_view = "\uf21d"
    strikethrough = "\uf0cc"
    stroopwafel = "\uf551"
    subscript = "\uf12c"
    suitcase = "\uf0f2"
    suitcase_medical = "\uf0fa"
    suitcase_rolling = "\uf5c1"
    sun = "\uf185"
    sun_plant_wilt = "\ue57a"
    superscript = "\uf12b"
    swatchbook = "\uf5c3"
    synagogue = "\uf69b"
    syringe = "\uf48e"
    table = "\uf0ce"
    table_cells = "\uf00a"
    table_cells_large = "\uf009"
    table_columns = "\uf0db"
    table_list = "\uf00b"
    table_tennis_paddle_ball = "\uf45d"
    tablet = "\uf3fb"
    tablet_button = "\uf10a"
    tablet_screen_button = "\uf3fa"
    tablets = "\uf490"
    tachograph_digital = "\uf566"
    tag = "\uf02b"
    tags = "\uf02c"
    tape = "\uf4db"
    tarp = "\ue57b"
    tarp_droplet = "\ue57c"
    taxi = "\uf1ba"
    teeth = "\uf62e"
    teeth_open = "\uf62f"
    temperature_arrow_down = "\ue03f"
    temperature_arrow_up = "\ue040"
    temperature_empty = "\uf2cb"
    temperature_full = "\uf2c7"
    temperature_half = "\uf2c9"
    temperature_high = "\uf769"
    temperature_low = "\uf76b"
    temperature_quarter = "\uf2ca"
    temperature_three_quarters = "\uf2c8"
    tenge_sign = "\uf7d7"
    tent = "\ue57d"
    tent_arrow_down_to_line = "\ue57e"
    tent_arrow_left_right = "\ue57f"
    tent_arrow_turn_left = "\ue580"
    tent_arrows_down = "\ue581"
    tents = "\ue582"
    terminal = "\uf120"
    text_height = "\uf034"
    text_slash = "\uf87d"
    text_width = "\uf035"
    thermometer = "\uf491"
    thumbs_down = "\uf165"
    thumbs_up = "\uf164"
    thumbtack = "\uf08d"
    ticket = "\uf145"
    ticket_simple = "\uf3ff"
    timeline = "\ue29c"
    toggle_off = "\uf204"
    toggle_on = "\uf205"
    toilet = "\uf7d8"
    toilet_paper = "\uf71e"
    toilet_paper_slash = "\ue072"
    toilet_portable = "\ue583"
    toilets_portable = "\ue584"
    toolbox = "\uf552"
    tooth = "\uf5c9"
    torii_gate = "\uf6a1"
    tornado = "\uf76f"
    tower_broadcast = "\uf519"
    tower_cell = "\ue585"
    tower_observation = "\ue586"
    tractor = "\uf722"
    trademark = "\uf25c"
    traffic_light = "\uf637"
    trailer = "\ue041"
    train = "\uf238"
    train_subway = "\uf239"
    train_tram = "\ue5b4"
    transgender = "\uf225"
    trash = "\uf1f8"
    trash_arrow_up = "\uf829"
    trash_can = "\uf2ed"
    trash_can_arrow_up = "\uf82a"
    tree = "\uf1bb"
    tree_city = "\ue587"
    triangle_exclamation = "\uf071"
    trophy = "\uf091"
    trowel = "\ue589"
    trowel_bricks = "\ue58a"
    truck = "\uf0d1"
    truck_arrow_right = "\ue58b"
    truck_droplet = "\ue58c"
    truck_fast = "\uf48b"
    truck_field = "\ue58d"
    truck_field_un = "\ue58e"
    truck_front = "\ue2b7"
    truck_medical = "\uf0f9"
    truck_monster = "\uf63b"
    truck_moving = "\uf4df"
    truck_pickup = "\uf63c"
    truck_plane = "\ue58f"
    truck_ramp_box = "\uf4de"
    tty = "\uf1e4"
    turkish_lira_sign = "\ue2bb"
    turn_down = "\uf3be"
    turn_up = "\uf3bf"
    tv = "\uf26c"
    umbrella = "\uf0e9"
    umbrella_beach = "\uf5ca"
    underline = "\uf0cd"
    universal_access = "\uf29a"
    unlock = "\uf09c"
    unlock_keyhole = "\uf13e"
    up_down = "\uf338"
    up_down_left_right = "\uf0b2"
    up_long = "\uf30c"
    up_right_and_down_left_from_center = "\uf424"
    up_right_from_square = "\uf35d"
    upload = "\uf093"
    user = "\uf007"
    user_astronaut = "\uf4fb"
    user_check = "\uf4fc"
    user_clock = "\uf4fd"
    user_doctor = "\uf0f0"
    user_gear = "\uf4fe"
    user_graduate = "\uf501"
    user_group = "\uf500"
    user_injured = "\uf728"
    user_large = "\uf406"
    user_large_slash = "\uf4fa"
    user_lock = "\uf502"
    user_minus = "\uf503"
    user_ninja = "\uf504"
    user_nurse = "\uf82f"
    user_pen = "\uf4ff"
    user_plus = "\uf234"
    user_secret = "\uf21b"
    user_shield = "\uf505"
    user_slash = "\uf506"
    user_tag = "\uf507"
    user_tie = "\uf508"
    user_xmark = "\uf235"
    users = "\uf0c0"
    users_between_lines = "\ue591"
    users_gear = "\uf509"
    users_line = "\ue592"
    users_rays = "\ue593"
    users_rectangle = "\ue594"
    users_slash = "\ue073"
    users_viewfinder = "\ue595"
    utensils = "\uf2e7"
    van_shuttle = "\uf5b6"
    vault = "\ue2c5"
    vector_square = "\uf5cb"
    venus = "\uf221"
    venus_double = "\uf226"
    venus_mars = "\uf228"
    vest = "\ue085"
    vest_patches = "\ue086"
    vial = "\uf492"
    vial_circle_check = "\ue596"
    vial_virus = "\ue597"
    vials = "\uf493"
    video = "\uf03d"
    video_slash = "\uf4e2"
    vihara = "\uf6a7"
    virus = "\ue074"
    virus_covid = "\ue4a8"
    virus_covid_slash = "\ue4a9"
    virus_slash = "\ue075"
    viruses = "\ue076"
    voicemail = "\uf897"
    volcano = "\uf770"
    volleyball = "\uf45f"
    volume_high = "\uf028"
    volume_low = "\uf027"
    volume_off = "\uf026"
    volume_xmark = "\uf6a9"
    vr_cardboard = "\uf729"
    walkie_talkie = "\uf8ef"
    wallet = "\uf555"
    wand_magic = "\uf0d0"
    wand_magic_sparkles = "\ue2ca"
    wand_sparkles = "\uf72b"
    warehouse = "\uf494"
    water = "\uf773"
    water_ladder = "\uf5c5"
    wave_square = "\uf83e"
    weight_hanging = "\uf5cd"
    weight_scale = "\uf496"
    wheat_awn = "\ue2cd"
    wheat_awn_circle_exclamation = "\ue598"
    wheelchair = "\uf193"
    wheelchair_move = "\ue2ce"
    whiskey_glass = "\uf7a0"
    wifi = "\uf1eb"
    wind = "\uf72e"
    window_maximize = "\uf2d0"
    window_minimize = "\uf2d1"
    window_restore = "\uf2d2"
    wine_bottle = "\uf72f"
    wine_glass = "\uf4e3"
    wine_glass_empty = "\uf5ce"
    won_sign = "\uf159"
    worm = "\ue599"
    wrench = "\uf0ad"
    x_ray = "\uf497"
    xmark = "\uf00d"
    xmarks_lines = "\ue59a"
    yen_sign = "\uf157"
    yin_yang = "\uf6ad"
