# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AvailabilityStateValues(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Availability status of the resource. When it is null, this availabilityStatus object represents
    an availability impacting event.
    """

    AVAILABLE = "Available"
    UNAVAILABLE = "Unavailable"
    DEGRADED = "Degraded"
    UNKNOWN = "Unknown"


class Enum8(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum8."""

    DEFAULT = "default"


class EventLevelValues(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Level of event."""

    CRITICAL = "Critical"
    ERROR = "Error"
    WARNING = "Warning"
    INFORMATIONAL = "Informational"


class EventSourceValues(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Source of event."""

    RESOURCE_HEALTH = "ResourceHealth"
    SERVICE_HEALTH = "ServiceHealth"


class EventStatusValues(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Current status of event."""

    ACTIVE = "Active"
    RESOLVED = "Resolved"


class EventTypeValues(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of event."""

    SERVICE_ISSUE = "ServiceIssue"
    PLANNED_MAINTENANCE = "PlannedMaintenance"
    HEALTH_ADVISORY = "HealthAdvisory"
    RCA = "RCA"
    EMERGING_ISSUES = "EmergingIssues"
    SECURITY_ADVISORY = "SecurityAdvisory"


class LevelValues(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Level of insight."""

    CRITICAL = "Critical"
    WARNING = "Warning"


class LinkTypeValues(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of link."""

    BUTTON = "Button"
    HYPERLINK = "Hyperlink"


class ReasonChronicityTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Chronicity of the availability transition."""

    TRANSIENT = "Transient"
    PERSISTENT = "Persistent"


class Scenario(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Scenario."""

    ALERTS = "Alerts"


class SeverityValues(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The severity level of this active event."""

    INFORMATION = "Information"
    WARNING = "Warning"
    ERROR = "Error"


class StageValues(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The stage of this active event."""

    ACTIVE = "Active"
    RESOLVE = "Resolve"
    ARCHIVED = "Archived"
