# Clients

## ws

```
$ ws connect ws://127.0.0.1:8765
Type Ctrl-D to exit prompt...
Connecting to url: ws://127.0.0.1:8765
> ws_connect: connected
Uri: /
Handshake Headers:
Connection: Upgrade
Date: Sat, 08 Jun 2019 16:43:29 GMT
Sec-WebSocket-Accept: kPCNwGa97y+7NWdAvHi/7/rA8AE=
Sec-WebSocket-Extensions: permessage-deflate; server_max_window_bits=15; client_max_window_bits=15
Server: Python/3.7 websockets/7.0
Upgrade: websocket
Received 13 bytes
ws_connect: received message: > Welcome !
ws_connect: connection closed: code 1006 reason Abnormal closure
```

## wscat

```
$ ./node_modules/.bin/wscat -c ws://127.0.0.1:8765
connected (press CTRL+C to quit)
< > Welcome !
disconnected (code: 1006)
```

# Server

```
$ honcho start
15:29:52 system             | nginx.1 started (pid=75372)
15:29:52 system             | send.1 started (pid=75373)
15:29:52 system             | websocket_server.1 started (pid=75374)
15:29:53 send.1             | [2020-01-05 15:29:53.414] [info] ws_send: Connecting to url: wss://localhost:8765
15:29:53 send.1             | [2020-01-05 15:29:53.415] [info] ws_send: Connecting...
15:29:53 send.1             | [2020-01-05 15:29:53.436] [info] ws_send: connected
15:29:53 send.1             | [2020-01-05 15:29:53.436] [info] ws_send: Sending...
15:29:53 send.1             | [2020-01-05 15:29:53.436] [info] Uri: /
15:29:53 send.1             | [2020-01-05 15:29:53.436] [info] Headers:
15:29:53 send.1             | [2020-01-05 15:29:53.436] [info] Connection: upgrade
15:29:53 send.1             | [2020-01-05 15:29:53.436] [info] Date: Sun, 05 Jan 2020 23:29:53 GMT
15:29:53 send.1             | [2020-01-05 15:29:53.436] [info] Sec-WebSocket-Accept: 2+7DV7Q0Ib3fxynZwaNTtsAepIk=
15:29:53 send.1             | [2020-01-05 15:29:53.436] [info] Server: nginx/1.15.9
15:29:53 send.1             | [2020-01-05 15:29:53.436] [info] Upgrade: websocket
15:29:53 send.1             | [2020-01-05 15:29:53.633] [info] load file from disk completed in 197
15:29:54 send.1             | [2020-01-05 15:29:54.267] [info] ws_send: Step 0 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.269] [info] ws_send: Step 1 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.271] [info] ws_send: Step 2 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.273] [info] ws_send: Step 3 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.275] [info] ws_send: Step 4 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.277] [info] ws_send: Step 5 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.278] [info] ws_send: Step 6 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.280] [info] ws_send: Step 7 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.282] [info] ws_send: Step 8 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.284] [info] ws_send: Step 9 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.286] [info] ws_send: Step 10 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.288] [info] ws_send: Step 11 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.289] [info] ws_send: Step 12 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.291] [info] ws_send: Step 13 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.293] [info] ws_send: Step 14 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.295] [info] ws_send: Step 15 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.297] [info] ws_send: Step 16 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.298] [info] ws_send: Step 17 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.300] [info] ws_send: Step 18 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.302] [info] ws_send: Step 19 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.304] [info] ws_send: Step 20 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.306] [info] ws_send: Step 21 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.308] [info] ws_send: Step 22 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.309] [info] ws_send: Step 23 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.311] [info] ws_send: Step 24 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.313] [info] ws_send: Step 25 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.315] [info] ws_send: Step 26 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.317] [info] ws_send: Step 27 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.319] [info] ws_send: Step 28 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.320] [info] ws_send: Step 29 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.322] [info] ws_send: Step 30 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.324] [info] ws_send: Step 31 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.326] [info] ws_send: Step 32 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.328] [info] ws_send: Step 33 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.329] [info] ws_send: Step 34 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.331] [info] ws_send: Step 35 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.333] [info] ws_send: Step 36 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.335] [info] ws_send: Step 37 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.337] [info] ws_send: Step 38 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.339] [info] ws_send: Step 39 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.340] [info] ws_send: Step 40 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.342] [info] ws_send: Step 41 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.344] [info] ws_send: Step 42 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.346] [info] ws_send: Step 43 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.348] [info] ws_send: Step 44 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.350] [info] ws_send: Step 45 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.351] [info] ws_send: Step 46 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.353] [info] ws_send: Step 47 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.355] [info] ws_send: Step 48 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.357] [info] ws_send: Step 49 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.359] [info] ws_send: Step 50 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.361] [info] ws_send: Step 51 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.362] [info] ws_send: Step 52 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.364] [info] ws_send: Step 53 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.366] [info] ws_send: Step 54 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.368] [info] ws_send: Step 55 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.370] [info] ws_send: Step 56 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.372] [info] ws_send: Step 57 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.373] [info] ws_send: Step 58 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.375] [info] ws_send: Step 59 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.377] [info] ws_send: Step 60 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.379] [info] ws_send: Step 61 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.381] [info] ws_send: Step 62 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.383] [info] ws_send: Step 63 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.384] [info] ws_send: Step 64 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.386] [info] ws_send: Step 65 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.388] [info] ws_send: Step 66 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.390] [info] ws_send: Step 67 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.392] [info] ws_send: Step 68 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.394] [info] ws_send: Step 69 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.395] [info] ws_send: Step 70 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.397] [info] ws_send: Step 71 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.399] [info] ws_send: Step 72 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.401] [info] ws_send: Step 73 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.403] [info] ws_send: Step 74 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.405] [info] ws_send: Step 75 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.407] [info] ws_send: Step 76 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.409] [info] ws_send: Step 77 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.411] [info] ws_send: Step 78 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.412] [info] ws_send: Step 79 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.414] [info] ws_send: Step 80 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.416] [info] ws_send: Step 81 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.418] [info] ws_send: Step 82 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.420] [info] ws_send: Step 83 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.421] [info] ws_send: Step 84 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.423] [info] ws_send: Step 85 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.425] [info] ws_send: Step 86 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.427] [info] ws_send: Step 87 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.429] [info] ws_send: Step 88 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.431] [info] ws_send: Step 89 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.432] [info] ws_send: Step 90 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.434] [info] ws_send: Step 91 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.436] [info] ws_send: Step 92 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.438] [info] ws_send: Step 93 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.440] [info] ws_send: Step 94 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.442] [info] ws_send: Step 95 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.444] [info] ws_send: Step 96 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.445] [info] ws_send: Step 97 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.447] [info] ws_send: Step 98 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.449] [info] ws_send: Step 99 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.451] [info] ws_send: Step 100 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.453] [info] ws_send: Step 101 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.454] [info] ws_send: Step 102 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.456] [info] ws_send: Step 103 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.458] [info] ws_send: Step 104 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.460] [info] ws_send: Step 105 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.462] [info] ws_send: Step 106 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.464] [info] ws_send: Step 107 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.465] [info] ws_send: Step 108 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.467] [info] ws_send: Step 109 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.469] [info] ws_send: Step 110 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.471] [info] ws_send: Step 111 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.473] [info] ws_send: Step 112 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.475] [info] ws_send: Step 113 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.476] [info] ws_send: Step 114 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.478] [info] ws_send: Step 115 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.480] [info] ws_send: Step 116 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.482] [info] ws_send: Step 117 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.484] [info] ws_send: Step 118 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.486] [info] ws_send: Step 119 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.488] [info] ws_send: Step 120 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.489] [info] ws_send: Step 121 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.491] [info] ws_send: Step 122 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.493] [info] ws_send: Step 123 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.495] [info] ws_send: Step 124 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.497] [info] ws_send: Step 125 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.499] [info] ws_send: Step 126 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.500] [info] ws_send: Step 127 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.502] [info] ws_send: Step 128 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.504] [info] ws_send: Step 129 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.506] [info] ws_send: Step 130 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.508] [info] ws_send: Step 131 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.509] [info] ws_send: Step 132 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.511] [info] ws_send: Step 133 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.513] [info] ws_send: Step 134 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.515] [info] ws_send: Step 135 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.517] [info] ws_send: Step 136 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.519] [info] ws_send: Step 137 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.520] [info] ws_send: Step 138 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.522] [info] ws_send: Step 139 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.524] [info] ws_send: Step 140 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.526] [info] ws_send: Step 141 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.528] [info] ws_send: Step 142 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.530] [info] ws_send: Step 143 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.531] [info] ws_send: Step 144 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.533] [info] ws_send: Step 145 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.535] [info] ws_send: Step 146 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.537] [info] ws_send: Step 147 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.539] [info] ws_send: Step 148 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.541] [info] ws_send: Step 149 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.542] [info] ws_send: Step 150 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.544] [info] ws_send: Step 151 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.546] [info] ws_send: Step 152 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.548] [info] ws_send: Step 153 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.550] [info] ws_send: Step 154 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.551] [info] ws_send: Step 155 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.553] [info] ws_send: Step 156 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.555] [info] ws_send: Step 157 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.557] [info] ws_send: Step 158 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.559] [info] ws_send: Step 159 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.561] [info] ws_send: Step 160 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.562] [info] ws_send: Step 161 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.564] [info] ws_send: Step 162 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.566] [info] ws_send: Step 163 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.568] [info] ws_send: Step 164 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.570] [info] ws_send: Step 165 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.571] [info] ws_send: Step 166 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.573] [info] ws_send: Step 167 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.575] [info] ws_send: Step 168 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.577] [info] ws_send: Step 169 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.579] [info] ws_send: Step 170 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.581] [info] ws_send: Step 171 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.582] [info] ws_send: Step 172 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.584] [info] ws_send: Step 173 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.586] [info] ws_send: Step 174 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.588] [info] ws_send: Step 175 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.590] [info] ws_send: Step 176 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.592] [info] ws_send: Step 177 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.593] [info] ws_send: Step 178 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.595] [info] ws_send: Step 179 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.597] [info] ws_send: Step 180 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.599] [info] ws_send: Step 181 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.601] [info] ws_send: Step 182 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.602] [info] ws_send: Step 183 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.604] [info] ws_send: Step 184 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.606] [info] ws_send: Step 185 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.608] [info] ws_send: Step 186 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.610] [info] ws_send: Step 187 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.612] [info] ws_send: Step 188 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.613] [info] ws_send: Step 189 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.615] [info] ws_send: Step 190 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.617] [info] ws_send: Step 191 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.619] [info] ws_send: Step 192 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.621] [info] ws_send: Step 193 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.622] [info] ws_send: Step 194 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.624] [info] ws_send: Step 195 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.626] [info] ws_send: Step 196 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.628] [info] ws_send: Step 197 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.630] [info] ws_send: Step 198 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.632] [info] ws_send: Step 199 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.633] [info] ws_send: Step 200 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.635] [info] ws_send: Step 201 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.637] [info] ws_send: Step 202 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.639] [info] ws_send: Step 203 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.641] [info] ws_send: Step 204 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.642] [info] ws_send: Step 205 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.644] [info] ws_send: Step 206 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.646] [info] ws_send: Step 207 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.648] [info] ws_send: Step 208 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.650] [info] ws_send: Step 209 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.652] [info] ws_send: Step 210 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.653] [info] ws_send: Step 211 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.655] [info] ws_send: Step 212 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.657] [info] ws_send: Step 213 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.659] [info] ws_send: Step 214 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.661] [info] ws_send: Step 215 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.663] [info] ws_send: Step 216 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.664] [info] ws_send: Step 217 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.666] [info] ws_send: Step 218 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.668] [info] ws_send: Step 219 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.670] [info] ws_send: Step 220 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.672] [info] ws_send: Step 221 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.674] [info] ws_send: Step 222 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.675] [info] ws_send: Step 223 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.677] [info] ws_send: Step 224 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.679] [info] ws_send: Step 225 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.681] [info] ws_send: Step 226 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.683] [info] ws_send: Step 227 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.685] [info] ws_send: Step 228 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.686] [info] ws_send: Step 229 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.688] [info] ws_send: Step 230 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.690] [info] ws_send: Step 231 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.692] [info] ws_send: Step 232 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.694] [info] ws_send: Step 233 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.695] [info] ws_send: Step 234 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.697] [info] ws_send: Step 235 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.699] [info] ws_send: Step 236 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.701] [info] ws_send: Step 237 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.703] [info] ws_send: Step 238 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.705] [info] ws_send: Step 239 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.707] [info] ws_send: Step 240 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.708] [info] ws_send: Step 241 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.710] [info] ws_send: Step 242 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.712] [info] ws_send: Step 243 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.714] [info] ws_send: Step 244 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.716] [info] ws_send: Step 245 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.718] [info] ws_send: Step 246 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.719] [info] ws_send: Step 247 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.721] [info] ws_send: Step 248 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.723] [info] ws_send: Step 249 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.725] [info] ws_send: Step 250 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.727] [info] ws_send: Step 251 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.729] [info] ws_send: Step 252 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.730] [info] ws_send: Step 253 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.732] [info] ws_send: Step 254 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.734] [info] ws_send: Step 255 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.736] [info] ws_send: Step 256 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.738] [info] ws_send: Step 257 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.740] [info] ws_send: Step 258 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.742] [info] ws_send: Step 259 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.743] [info] ws_send: Step 260 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.745] [info] ws_send: Step 261 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.747] [info] ws_send: Step 262 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.749] [info] ws_send: Step 263 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.751] [info] ws_send: Step 264 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.752] [info] ws_send: Step 265 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.754] [info] ws_send: Step 266 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.756] [info] ws_send: Step 267 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.758] [info] ws_send: Step 268 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.760] [info] ws_send: Step 269 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.762] [info] ws_send: Step 270 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.763] [info] ws_send: Step 271 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.765] [info] ws_send: Step 272 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.767] [info] ws_send: Step 273 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.769] [info] ws_send: Step 274 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.771] [info] ws_send: Step 275 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.772] [info] ws_send: Step 276 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.774] [info] ws_send: Step 277 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.776] [info] ws_send: Step 278 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.778] [info] ws_send: Step 279 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.780] [info] ws_send: Step 280 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.782] [info] ws_send: Step 281 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.783] [info] ws_send: Step 282 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.785] [info] ws_send: Step 283 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.787] [info] ws_send: Step 284 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.789] [info] ws_send: Step 285 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.791] [info] ws_send: Step 286 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.793] [info] ws_send: Step 287 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.794] [info] ws_send: Step 288 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.796] [info] ws_send: Step 289 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.798] [info] ws_send: Step 290 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.800] [info] ws_send: Step 291 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.802] [info] ws_send: Step 292 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.804] [info] ws_send: Step 293 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.805] [info] ws_send: Step 294 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.807] [info] ws_send: Step 295 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.809] [info] ws_send: Step 296 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.811] [info] ws_send: Step 297 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.813] [info] ws_send: Step 298 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.814] [info] ws_send: Step 299 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.816] [info] ws_send: Step 300 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.818] [info] ws_send: Step 301 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.820] [info] ws_send: Step 302 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.822] [info] ws_send: Step 303 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.824] [info] ws_send: Step 304 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.825] [info] ws_send: Step 305 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.827] [info] ws_send: Step 306 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.829] [info] ws_send: Step 307 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.831] [info] ws_send: Step 308 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.833] [info] ws_send: Step 309 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.835] [info] ws_send: Step 310 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.836] [info] ws_send: Step 311 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.838] [info] ws_send: Step 312 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.840] [info] ws_send: Step 313 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.842] [info] ws_send: Step 314 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.844] [info] ws_send: Step 315 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.845] [info] ws_send: Step 316 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.847] [info] ws_send: Step 317 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.849] [info] ws_send: Step 318 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.851] [info] ws_send: Step 319 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.853] [info] ws_send: Step 320 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.855] [info] ws_send: Step 321 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.856] [info] ws_send: Step 322 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.858] [info] ws_send: Step 323 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.860] [info] ws_send: Step 324 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.862] [info] ws_send: Step 325 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.864] [info] ws_send: Step 326 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.866] [info] ws_send: Step 327 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.867] [info] ws_send: Step 328 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.869] [info] ws_send: Step 329 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.871] [info] ws_send: Step 330 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.873] [info] ws_send: Step 331 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.875] [info] ws_send: Step 332 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.876] [info] ws_send: Step 333 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.878] [info] ws_send: Step 334 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.880] [info] ws_send: Step 335 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.882] [info] ws_send: Step 336 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.884] [info] ws_send: Step 337 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.886] [info] ws_send: Step 338 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.888] [info] ws_send: Step 339 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.889] [info] ws_send: Step 340 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.891] [info] ws_send: Step 341 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.893] [info] ws_send: Step 342 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.895] [info] ws_send: Step 343 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.897] [info] ws_send: Step 344 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.899] [info] ws_send: Step 345 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.900] [info] ws_send: Step 346 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.902] [info] ws_send: Step 347 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.904] [info] ws_send: Step 348 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.906] [info] ws_send: Step 349 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.908] [info] ws_send: Step 350 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.910] [info] ws_send: Step 351 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.911] [info] ws_send: Step 352 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.913] [info] ws_send: Step 353 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.915] [info] ws_send: Step 354 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.917] [info] ws_send: Step 355 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.919] [info] ws_send: Step 356 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.920] [info] ws_send: Step 357 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.922] [info] ws_send: Step 358 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.924] [info] ws_send: Step 359 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.926] [info] ws_send: Step 360 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.928] [info] ws_send: Step 361 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.930] [info] ws_send: Step 362 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.932] [info] ws_send: Step 363 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.933] [info] ws_send: Step 364 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.935] [info] ws_send: Step 365 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.937] [info] ws_send: Step 366 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.939] [info] ws_send: Step 367 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.941] [info] ws_send: Step 368 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.943] [info] ws_send: Step 369 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.944] [info] ws_send: Step 370 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.946] [info] ws_send: Step 371 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.948] [info] ws_send: Step 372 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.950] [info] ws_send: Step 373 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.952] [info] ws_send: Step 374 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.954] [info] ws_send: Step 375 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.955] [info] ws_send: Step 376 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.957] [info] ws_send: Step 377 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.959] [info] ws_send: Step 378 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.961] [info] ws_send: Step 379 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.963] [info] ws_send: Step 380 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.965] [info] ws_send: Step 381 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.966] [info] ws_send: Step 382 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.968] [info] ws_send: Step 383 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.970] [info] ws_send: Step 384 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.972] [info] ws_send: Step 385 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.974] [info] ws_send: Step 386 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.976] [info] ws_send: Step 387 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.977] [info] ws_send: Step 388 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.979] [info] ws_send: Step 389 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.981] [info] ws_send: Step 390 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.983] [info] ws_send: Step 391 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.985] [info] ws_send: Step 392 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.986] [info] ws_send: Step 393 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.988] [info] ws_send: Step 394 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.990] [info] ws_send: Step 395 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.992] [info] ws_send: Step 396 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.994] [info] ws_send: Step 397 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.996] [info] ws_send: Step 398 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.997] [info] ws_send: Step 399 out of 768
15:29:54 send.1             | [2020-01-05 15:29:54.999] [info] ws_send: Step 400 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.001] [info] ws_send: Step 401 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.003] [info] ws_send: Step 402 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.005] [info] ws_send: Step 403 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.007] [info] ws_send: Step 404 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.009] [info] ws_send: Step 405 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.010] [info] ws_send: Step 406 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.012] [info] ws_send: Step 407 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.014] [info] ws_send: Step 408 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.016] [info] ws_send: Step 409 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.018] [info] ws_send: Step 410 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.020] [info] ws_send: Step 411 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.021] [info] ws_send: Step 412 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.023] [info] ws_send: Step 413 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.025] [info] ws_send: Step 414 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.027] [info] ws_send: Step 415 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.029] [info] ws_send: Step 416 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.030] [info] ws_send: Step 417 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.032] [info] ws_send: Step 418 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.034] [info] ws_send: Step 419 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.036] [info] ws_send: Step 420 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.038] [info] ws_send: Step 421 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.040] [info] ws_send: Step 422 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.041] [info] ws_send: Step 423 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.043] [info] ws_send: Step 424 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.045] [info] ws_send: Step 425 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.047] [info] ws_send: Step 426 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.049] [info] ws_send: Step 427 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.051] [info] ws_send: Step 428 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.052] [info] ws_send: Step 429 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.054] [info] ws_send: Step 430 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.056] [info] ws_send: Step 431 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.058] [info] ws_send: Step 432 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.060] [info] ws_send: Step 433 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.062] [info] ws_send: Step 434 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.063] [info] ws_send: Step 435 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.065] [info] ws_send: Step 436 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.067] [info] ws_send: Step 437 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.069] [info] ws_send: Step 438 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.071] [info] ws_send: Step 439 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.073] [info] ws_send: Step 440 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.075] [info] ws_send: Step 441 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.077] [info] ws_send: Step 442 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.078] [info] ws_send: Step 443 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.080] [info] ws_send: Step 444 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.082] [info] ws_send: Step 445 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.084] [info] ws_send: Step 446 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.086] [info] ws_send: Step 447 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.088] [info] ws_send: Step 448 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.090] [info] ws_send: Step 449 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.091] [info] ws_send: Step 450 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.093] [info] ws_send: Step 451 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.095] [info] ws_send: Step 452 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.097] [info] ws_send: Step 453 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.099] [info] ws_send: Step 454 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.101] [info] ws_send: Step 455 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.102] [info] ws_send: Step 456 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.104] [info] ws_send: Step 457 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.106] [info] ws_send: Step 458 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.108] [info] ws_send: Step 459 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.110] [info] ws_send: Step 460 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.112] [info] ws_send: Step 461 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.113] [info] ws_send: Step 462 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.115] [info] ws_send: Step 463 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.117] [info] ws_send: Step 464 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.119] [info] ws_send: Step 465 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.121] [info] ws_send: Step 466 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.123] [info] ws_send: Step 467 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.124] [info] ws_send: Step 468 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.126] [info] ws_send: Step 469 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.128] [info] ws_send: Step 470 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.130] [info] ws_send: Step 471 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.132] [info] ws_send: Step 472 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.134] [info] ws_send: Step 473 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.135] [info] ws_send: Step 474 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.137] [info] ws_send: Step 475 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.139] [info] ws_send: Step 476 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.141] [info] ws_send: Step 477 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.143] [info] ws_send: Step 478 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.145] [info] ws_send: Step 479 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.146] [info] ws_send: Step 480 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.148] [info] ws_send: Step 481 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.150] [info] ws_send: Step 482 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.152] [info] ws_send: Step 483 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.154] [info] ws_send: Step 484 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.155] [info] ws_send: Step 485 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.157] [info] ws_send: Step 486 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.159] [info] ws_send: Step 487 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.161] [info] ws_send: Step 488 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.163] [info] ws_send: Step 489 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.165] [info] ws_send: Step 490 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.166] [info] ws_send: Step 491 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.168] [info] ws_send: Step 492 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.170] [info] ws_send: Step 493 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.172] [info] ws_send: Step 494 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.174] [info] ws_send: Step 495 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.176] [info] ws_send: Step 496 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.177] [info] ws_send: Step 497 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.179] [info] ws_send: Step 498 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.181] [info] ws_send: Step 499 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.183] [info] ws_send: Step 500 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.185] [info] ws_send: Step 501 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.186] [info] ws_send: Step 502 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.188] [info] ws_send: Step 503 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.190] [info] ws_send: Step 504 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.192] [info] ws_send: Step 505 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.194] [info] ws_send: Step 506 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.196] [info] ws_send: Step 507 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.198] [info] ws_send: Step 508 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.199] [info] ws_send: Step 509 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.201] [info] ws_send: Step 510 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.203] [info] ws_send: Step 511 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.205] [info] ws_send: Step 512 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.207] [info] ws_send: Step 513 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.209] [info] ws_send: Step 514 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.210] [info] ws_send: Step 515 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.212] [info] ws_send: Step 516 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.214] [info] ws_send: Step 517 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.216] [info] ws_send: Step 518 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.218] [info] ws_send: Step 519 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.220] [info] ws_send: Step 520 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.221] [info] ws_send: Step 521 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.223] [info] ws_send: Step 522 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.225] [info] ws_send: Step 523 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.227] [info] ws_send: Step 524 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.229] [info] ws_send: Step 525 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.230] [info] ws_send: Step 526 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.232] [info] ws_send: Step 527 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.234] [info] ws_send: Step 528 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.236] [info] ws_send: Step 529 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.238] [info] ws_send: Step 530 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.240] [info] ws_send: Step 531 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.241] [info] ws_send: Step 532 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.243] [info] ws_send: Step 533 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.245] [info] ws_send: Step 534 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.247] [info] ws_send: Step 535 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.249] [info] ws_send: Step 536 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.250] [info] ws_send: Step 537 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.252] [info] ws_send: Step 538 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.254] [info] ws_send: Step 539 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.256] [info] ws_send: Step 540 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.258] [info] ws_send: Step 541 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.260] [info] ws_send: Step 542 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.261] [info] ws_send: Step 543 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.263] [info] ws_send: Step 544 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.265] [info] ws_send: Step 545 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.267] [info] ws_send: Step 546 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.269] [info] ws_send: Step 547 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.271] [info] ws_send: Step 548 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.272] [info] ws_send: Step 549 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.274] [info] ws_send: Step 550 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.276] [info] ws_send: Step 551 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.278] [info] ws_send: Step 552 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.280] [info] ws_send: Step 553 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.282] [info] ws_send: Step 554 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.283] [info] ws_send: Step 555 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.285] [info] ws_send: Step 556 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.287] [info] ws_send: Step 557 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.289] [info] ws_send: Step 558 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.291] [info] ws_send: Step 559 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.293] [info] ws_send: Step 560 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.294] [info] ws_send: Step 561 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.296] [info] ws_send: Step 562 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.298] [info] ws_send: Step 563 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.300] [info] ws_send: Step 564 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.302] [info] ws_send: Step 565 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.304] [info] ws_send: Step 566 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.305] [info] ws_send: Step 567 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.307] [info] ws_send: Step 568 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.309] [info] ws_send: Step 569 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.311] [info] ws_send: Step 570 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.313] [info] ws_send: Step 571 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.315] [info] ws_send: Step 572 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.316] [info] ws_send: Step 573 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.318] [info] ws_send: Step 574 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.320] [info] ws_send: Step 575 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.322] [info] ws_send: Step 576 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.324] [info] ws_send: Step 577 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.326] [info] ws_send: Step 578 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.327] [info] ws_send: Step 579 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.329] [info] ws_send: Step 580 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.331] [info] ws_send: Step 581 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.333] [info] ws_send: Step 582 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.335] [info] ws_send: Step 583 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.337] [info] ws_send: Step 584 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.338] [info] ws_send: Step 585 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.340] [info] ws_send: Step 586 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.342] [info] ws_send: Step 587 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.344] [info] ws_send: Step 588 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.346] [info] ws_send: Step 589 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.347] [info] ws_send: Step 590 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.349] [info] ws_send: Step 591 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.351] [info] ws_send: Step 592 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.353] [info] ws_send: Step 593 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.355] [info] ws_send: Step 594 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.357] [info] ws_send: Step 595 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.359] [info] ws_send: Step 596 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.360] [info] ws_send: Step 597 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.362] [info] ws_send: Step 598 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.364] [info] ws_send: Step 599 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.366] [info] ws_send: Step 600 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.368] [info] ws_send: Step 601 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.370] [info] ws_send: Step 602 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.371] [info] ws_send: Step 603 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.373] [info] ws_send: Step 604 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.375] [info] ws_send: Step 605 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.377] [info] ws_send: Step 606 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.379] [info] ws_send: Step 607 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.381] [info] ws_send: Step 608 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.382] [info] ws_send: Step 609 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.384] [info] ws_send: Step 610 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.386] [info] ws_send: Step 611 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.388] [info] ws_send: Step 612 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.390] [info] ws_send: Step 613 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.392] [info] ws_send: Step 614 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.393] [info] ws_send: Step 615 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.395] [info] ws_send: Step 616 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.397] [info] ws_send: Step 617 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.399] [info] ws_send: Step 618 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.401] [info] ws_send: Step 619 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.403] [info] ws_send: Step 620 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.404] [info] ws_send: Step 621 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.406] [info] ws_send: Step 622 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.408] [info] ws_send: Step 623 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.410] [info] ws_send: Step 624 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.412] [info] ws_send: Step 625 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.414] [info] ws_send: Step 626 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.415] [info] ws_send: Step 627 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.417] [info] ws_send: Step 628 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.419] [info] ws_send: Step 629 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.421] [info] ws_send: Step 630 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.423] [info] ws_send: Step 631 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.425] [info] ws_send: Step 632 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.427] [info] ws_send: Step 633 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.428] [info] ws_send: Step 634 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.430] [info] ws_send: Step 635 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.432] [info] ws_send: Step 636 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.434] [info] ws_send: Step 637 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.436] [info] ws_send: Step 638 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.438] [info] ws_send: Step 639 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.439] [info] ws_send: Step 640 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.441] [info] ws_send: Step 641 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.443] [info] ws_send: Step 642 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.445] [info] ws_send: Step 643 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.447] [info] ws_send: Step 644 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.449] [info] ws_send: Step 645 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.450] [info] ws_send: Step 646 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.452] [info] ws_send: Step 647 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.454] [info] ws_send: Step 648 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.456] [info] ws_send: Step 649 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.458] [info] ws_send: Step 650 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.460] [info] ws_send: Step 651 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.461] [info] ws_send: Step 652 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.463] [info] ws_send: Step 653 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.465] [info] ws_send: Step 654 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.467] [info] ws_send: Step 655 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.469] [info] ws_send: Step 656 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.471] [info] ws_send: Step 657 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.472] [info] ws_send: Step 658 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.474] [info] ws_send: Step 659 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.476] [info] ws_send: Step 660 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.478] [info] ws_send: Step 661 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.480] [info] ws_send: Step 662 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.482] [info] ws_send: Step 663 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.483] [info] ws_send: Step 664 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.485] [info] ws_send: Step 665 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.487] [info] ws_send: Step 666 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.489] [info] ws_send: Step 667 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.491] [info] ws_send: Step 668 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.493] [info] ws_send: Step 669 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.494] [info] ws_send: Step 670 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.496] [info] ws_send: Step 671 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.498] [info] ws_send: Step 672 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.500] [info] ws_send: Step 673 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.502] [info] ws_send: Step 674 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.503] [info] ws_send: Step 675 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.505] [info] ws_send: Step 676 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.507] [info] ws_send: Step 677 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.509] [info] ws_send: Step 678 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.511] [info] ws_send: Step 679 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.513] [info] ws_send: Step 680 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.514] [info] ws_send: Step 681 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.516] [info] ws_send: Step 682 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.518] [info] ws_send: Step 683 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.520] [info] ws_send: Step 684 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.522] [info] ws_send: Step 685 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.524] [info] ws_send: Step 686 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.525] [info] ws_send: Step 687 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.527] [info] ws_send: Step 688 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.529] [info] ws_send: Step 689 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.531] [info] ws_send: Step 690 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.533] [info] ws_send: Step 691 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.535] [info] ws_send: Step 692 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.536] [info] ws_send: Step 693 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.538] [info] ws_send: Step 694 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.540] [info] ws_send: Step 695 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.542] [info] ws_send: Step 696 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.544] [info] ws_send: Step 697 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.545] [info] ws_send: Step 698 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.547] [info] ws_send: Step 699 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.549] [info] ws_send: Step 700 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.551] [info] ws_send: Step 701 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.553] [info] ws_send: Step 702 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.555] [info] ws_send: Step 703 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.556] [info] ws_send: Step 704 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.558] [info] ws_send: Step 705 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.560] [info] ws_send: Step 706 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.562] [info] ws_send: Step 707 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.564] [info] ws_send: Step 708 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.566] [info] ws_send: Step 709 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.567] [info] ws_send: Step 710 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.569] [info] ws_send: Step 711 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.571] [info] ws_send: Step 712 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.573] [info] ws_send: Step 713 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.575] [info] ws_send: Step 714 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.576] [info] ws_send: Step 715 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.578] [info] ws_send: Step 716 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.580] [info] ws_send: Step 717 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.582] [info] ws_send: Step 718 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.584] [info] ws_send: Step 719 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.586] [info] ws_send: Step 720 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.587] [info] ws_send: Step 721 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.589] [info] ws_send: Step 722 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.591] [info] ws_send: Step 723 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.593] [info] ws_send: Step 724 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.595] [info] ws_send: Step 725 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.597] [info] ws_send: Step 726 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.598] [info] ws_send: Step 727 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.600] [info] ws_send: Step 728 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.602] [info] ws_send: Step 729 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.604] [info] ws_send: Step 730 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.606] [info] ws_send: Step 731 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.607] [info] ws_send: Step 732 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.609] [info] ws_send: Step 733 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.611] [info] ws_send: Step 734 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.613] [info] ws_send: Step 735 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.615] [info] ws_send: Step 736 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.617] [info] ws_send: Step 737 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.618] [info] ws_send: Step 738 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.620] [info] ws_send: Step 739 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.622] [info] ws_send: Step 740 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.624] [info] ws_send: Step 741 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.626] [info] ws_send: Step 742 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.628] [info] ws_send: Step 743 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.630] [info] ws_send: Step 744 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.632] [info] ws_send: Step 745 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.633] [info] ws_send: Step 746 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.635] [info] ws_send: Step 747 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.637] [info] ws_send: Step 748 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.639] [info] ws_send: Step 749 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.641] [info] ws_send: Step 750 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.642] [info] ws_send: Step 751 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.644] [info] ws_send: Step 752 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.646] [info] ws_send: Step 753 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.648] [info] ws_send: Step 754 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.650] [info] ws_send: Step 755 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.652] [info] ws_send: Step 756 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.653] [info] ws_send: Step 757 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.655] [info] ws_send: Step 758 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.657] [info] ws_send: Step 759 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.659] [info] ws_send: Step 760 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.661] [info] ws_send: Step 761 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.662] [info] ws_send: Step 762 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.664] [info] ws_send: Step 763 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.666] [info] ws_send: Step 764 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.668] [info] ws_send: Step 765 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.670] [info] ws_send: Step 766 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.673] [info] ws_send: Step 767 out of 768
15:29:55 send.1             | [2020-01-05 15:29:55.676] [info] ws_send: 0 bytes left to be sent
15:29:55 send.1             | [2020-01-05 15:29:55.689] [info] Sending file through websocket completed in 1801
15:29:55 send.1             | [2020-01-05 15:29:55.689] [info] ws_send: Send transfer rate: 13 MB/s
15:29:56 send.1             | [2020-01-05 15:29:56.142] [info] ws_send: Waiting for ack...
15:29:57 send.1             | [2020-01-05 15:29:57.399] [info] ws_send: received message (25183026 bytes)
15:29:57 send.1             | [2020-01-05 15:29:57.399] [info] ws_send: Done !
15:29:59 send.1             | [2020-01-05 15:29:59.233] [info] ws_send: connection closed: code 1000 reason Normal closure
15:29:59 send.1             |
15:29:59 system             | send.1 stopped (rc=0)
15:29:59 system             | sending SIGTERM to nginx.1 (pid 75372)
15:29:59 system             | sending SIGTERM to websocket_server.1 (pid 75374)
15:29:59 system             | nginx.1 stopped (rc=0)
15:29:59 system             | websocket_server.1 stopped (rc=-15)
```

## Sending large files over SSL

Running inside docker

```
$ make docker && make server_ssl
```

On the client

```
$ make ws_mbedtls && cp build/ws/ws /usr/local/bin/ws && ws send --verify_none wss://localhost:8766 /tmp/big_file
```
