---
id: fast-foundation.anchoredregionconfig
title: AnchoredRegionConfig interface
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[@microsoft/fast-foundation](./fast-foundation.md) &gt; [AnchoredRegionConfig](./fast-foundation.anchoredregionconfig.md)

## AnchoredRegionConfig interface

A utility interface to store anchored region configurations that correspond to various common flyout positioning schemes

<b>Signature:</b>

```typescript
export interface AnchoredRegionConfig 
```

## Properties

|  Property | Type | Description |
|  --- | --- | --- |
|  [autoUpdateMode](./fast-foundation.anchoredregionconfig.autoupdatemode.md) | [AutoUpdateMode](./fast-foundation.autoupdatemode.md) | The auto-update setting of the component |
|  [fixedPlacement](./fast-foundation.anchoredregionconfig.fixedplacement.md) | boolean | Whether the region is positioned using css "position: fixed". Otherwise the region uses "position: absolute". Fixed placement allows the region to break out of parent containers, |
|  [horizontalDefaultPosition](./fast-foundation.anchoredregionconfig.horizontaldefaultposition.md) | [HorizontalPosition](./fast-foundation.horizontalposition.md) | The default horizontal position of the region relative to the anchor element |
|  [horizontalInset](./fast-foundation.anchoredregionconfig.horizontalinset.md) | boolean | hether the region overlaps the anchor on the horizontal axis |
|  [horizontalPositioningMode](./fast-foundation.anchoredregionconfig.horizontalpositioningmode.md) | [AxisPositioningMode](./fast-foundation.axispositioningmode.md) | Sets what logic the component uses to determine horizontal placement. |
|  [horizontalScaling](./fast-foundation.anchoredregionconfig.horizontalscaling.md) | [AxisScalingMode](./fast-foundation.axisscalingmode.md) | Defines how the width of the region is calculate |
|  [horizontalThreshold](./fast-foundation.anchoredregionconfig.horizontalthreshold.md) | number | How short the space allocated to the default position has to be before the widest area is selected for layout |
|  [horizontalViewportLock](./fast-foundation.anchoredregionconfig.horizontalviewportlock.md) | boolean | Whether the region remains in the viewport (ie. detaches from the anchor) on the horizontal axis |
|  [verticalDefaultPosition](./fast-foundation.anchoredregionconfig.verticaldefaultposition.md) | [VerticalPosition](./fast-foundation.verticalposition.md) | The default vertical position of the region relative to the anchor element |
|  [verticalInset](./fast-foundation.anchoredregionconfig.verticalinset.md) | boolean | Whether the region overlaps the anchor on the vertical axis |
|  [verticalPositioningMode](./fast-foundation.anchoredregionconfig.verticalpositioningmode.md) | [AxisPositioningMode](./fast-foundation.axispositioningmode.md) | Sets what logic the component uses to determine vertical placement. |
|  [verticalScaling](./fast-foundation.anchoredregionconfig.verticalscaling.md) | [AxisScalingMode](./fast-foundation.axisscalingmode.md) | Defines how the height of the region is calculated |
|  [verticalThreshold](./fast-foundation.anchoredregionconfig.verticalthreshold.md) | number | How short the space allocated to the default position has to be before the tallest area is selected for layout |
|  [verticalViewportLock](./fast-foundation.anchoredregionconfig.verticalviewportlock.md) | boolean | Whether the region remains in the viewport (ie. detaches from the anchor) on the vertical axis |
