C (C) Copyright 1996-2016 ECMWF.
C 
C This software is licensed under the terms of the Apache Licence Version 2.0
C which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
C In applying this licence, ECMWF does not waive the privileges and immunities 
C granted to it by virtue of its status as an intergovernmental organisation nor
C does it submit to any jurisdiction.
C

      PROGRAM COASTRES

C     This program is intended to test different resolution coastlines
C     under Magics++ in order to determine how to define the automatic
C     coastline resolution selection algorithm.


      PARAMETER (RESLO=1.0)
      PARAMETER (RESHI=0.2)

      PARAMETER (NLEV=2)
      DIMENSION  RLEV (NLEV)
      DATA       RLEV /580., 590./


C     Open MAGICS and set the output device

      CALL POPEN
      CALL PARSE_COMMAND_LINE ('coast_res')




C     Set up the paper size

c      CALL PSETR ('SUPER_PAGE_Y_LENGTH', 21.0)
c      CALL PSETR ('SUPER_PAGE_X_LENGTH', 29.7)
c      CALL PSETR ('SUPER_PAGE_Y_LENGTH', 10.5)
c      CALL PSETR ('SUPER_PAGE_X_LENGTH', 14.85)
c      CALL PSETR ('PAGE_Y_LENGTH', 10.5)
c      CALL PSETR ('PAGE_X_LENGTH', 14.85)



C     Set up the coastline attributes

c      CALL PSETC ('MAP_COASTLINE_PATH',      '/scratch/coast_0.1.nc')
c      CALL PSETC ('MAP_COASTLINE_PATH',           'coast_test.nc')
      CALL PSETC ('MAP_GRID_COLOUR',              'GREY') 
      CALL PSETR ('MAP_GRID_LATITUDE_INCREMENT',   10.0)
      CALL PSETR ('MAP_GRID_LONGITUDE_INCREMENT',  20.0)
      CALL PSETC ('MAP_COASTLINE',                'ON')
      CALL PSETC ('MAP_COASTLINE_COLOUR',         'BLACK')


      

C     Set up the title text

      CALL PSETI ('TEXT_LINE_COUNT',     2)
      CALL PSETC ('TEXT_JUSTIFICATION', 'CENTRE')




C     First page, this time using the global area

C                       LEFT , RIGHT, TOP , BOTTOM, FACTOR
C      CALL COAST_TEST (-180.0, 180.0, 90.0, -90.0, 0.15, 0)
C      CALL COAST_TEST (-180.0, 180.0, 90.0, -90.0, 0.2, 0)



C     Now zoom in a bit

C                       LEFT , RIGHT, TOP , BOTTOM, FACTOR

c      CALL COAST_TEST (-180.0, 180.0, 90.0, -90.0,  '0.04', 0)



C     List of selected factors/areas

c      CALL COAST_TEST (-180.0, 180.0, 90.0, -90.0,  '0.1', 0)
c      CALL COAST_TEST (-160.0, 160.0, 80.0, -80.0,  '0.1', 0)
c      CALL COAST_TEST (-135.0, 135.0, 68.0, -68.0,  '0.1', 0)
c      CALL COAST_TEST (-90.0, 90.0, 45.0, -45.0, '0.1', 0)
c      CALL COAST_TEST (-70.0, 70.0, 65.0, -5.0, '0.1', 0)
c      CALL COAST_TEST (-60.0, 60.0, 55.0, 5.0, '0.1', 0)
c      CALL COAST_TEST (-45.0, 45.0, 75.0, 35.0, '0.08', 0)
c      CALL COAST_TEST (-35.0, 35.0, 65.0, 40.0, '0.08', 1)
c      CALL COAST_TEST (-30.0, 30.0, 65.0, 40.0, '0.04', 1)
c      CALL COAST_TEST (-12.0, 42.0, 75.0, 35.0, '0.04', 1)
c      CALL COAST_TEST (-12.0, 10.0, 65.0, 50.0, '0.04', 0)
c      CALL COAST_TEST (-15.0, 10.0, 70.0, 50.0, '0.04', 0)
c      CALL COAST_TEST (-11.0, 5.0, 60.0, 50.0, '0.1', 0)



C      Misc
      CALL COAST_TEST (-180.0, 180.0, 90.0, -90.0,  '0.4',  0)

      CALL COAST_TEST (-160.0, 160.0, 80.0, -80.0, '0.075', 1)
      CALL COAST_TEST (-135.0, 135.0, 68.0, -68.0, '0.075', 1)
      CALL COAST_TEST (-90.0, 90.0, 45.0, -45.0, '0.075', 1)
      CALL COAST_TEST (-45.0, 45.0, 20.0, -20.0, '0.15', 1)
      CALL COAST_TEST (-45.0, 45.0, 70.0, 30.0, '0.15', 1)
      CALL COAST_TEST (-15.0, 45.0, 70.0, 35.0, '0.15', 1)
      CALL COAST_TEST (-15.0, 5.0, 60.0, 50.0, '0.025', 1)



C     Close

      CALL PCLOSE

      STOP
      END



      SUBROUTINE COAST_TEST (RLEFT, RIGHT, RTOP, RBOT, FACTOR, INEW)
      
          CHARACTER*80  TITLE
          CHARACTER*32  COASTFILE
          CHARACTER*(*) FACTOR
          


C         Optionally start a new page

          IF (INEW == 1) THEN
            CALL PNEW  ('SUPER_PAGE')
          END IF


C         Set up the geographical area

          CALL PSETR ('SUBPAGE_LOWER_LEFT_LATITUDE',    RBOT)
          CALL PSETR ('SUBPAGE_LOWER_LEFT_LONGITUDE',   RLEFT)
          CALL PSETR ('SUBPAGE_UPPER_RIGHT_LATITUDE',   RTOP)
          CALL PSETR ('SUBPAGE_UPPER_RIGHT_LONGITUDE',  RIGHT)


C         We need to draw contours so that the automatic contour algorithm
C         can tell us the actual paper area

c          CALL PSETC  ('GRIB_INPUT_FILE_NAME', 'data/z500.grb')
c          CALL PGRIB
c          CALL PSETC  ('CONTOUR_LEVEL_SELECTION_TYPE', 'LEVEL_LIST')
c          CALL PSET1R ('CONTOUR_LEVEL_LIST',            RLEV, NLEV)      




C         Plot the coastlines - one full res, one scaled

          COASTFILE = 'coast_' // FACTOR // '.nc'
c          CALL PSETC ('MAP_COASTLINE_PATH',  COASTFILE)
c          CALL PSETC ('MAP_COASTLINE_PATH',  'coast.nc')

c          CALL PSETC ('MAP_COASTLINE_COLOUR', 'BLACK')
c          CALL PCOAST
CCC          CALL PSETR ('MAP_COASTLINE_SIMPLIFICATION_FACTOR', FACTOR)
CCC          CALL PSETR ('MAP_COASTLINE_SIMPLIFICATION_FACTOR', 0.1)
C          CALL PSETC ('MAP_COASTLINE_COLOUR', 'RED')
          CALL PCOAST


C         Create and plot the title

          WRITE(TITLE,'(A,4F6.1,A,A)') '(L,R,T,B): ',
     X          RLEFT, RIGHT, RTOP, RBOT, '  Factor: ', FACTOR
          CALL PSETC ('TEXT_LINE_1', TITLE)

          WRITE(TITLE,'(A,2F6.1)') '(W,H): ',
     X          RIGHT - RLEFT, RTOP - RBOT
          CALL PSETC ('TEXT_LINE_2', TITLE)

          CALL PTEXT
c          CALL PCONT

      RETURN
      END



C --------------------------------------------------------------------
C     PARSE_COMMAND_LINE
C     Checks the command-line for any arguments.
C     Arguments can come in pairs. Currently supported arguments are:
C     PROJECTION <CYLINDRICAL | POLAR_STEREOGRAPHIC>
C     DEVICE <PS | SVG | PNG>
C     e.g. Run the program with:
C       <progname> PROJECTION CYLINDRICAL  DEVICE SVG
C --------------------------------------------------------------------

      SUBROUTINE PARSE_COMMAND_LINE (OUTROOTNAME)

      CHARACTER*32 ARG
      CHARACTER*64 ID_TEXT
      CHARACTER*32 PROJECTION
      CHARACTER*32 DEVICE
      CHARACTER*48 EXENAME
      CHARACTER*8  MINIMAL
      CHARACTER*8  SEPARATOR
      CHARACTER*64 OUTNAME
      CHARACTER*(*) OUTROOTNAME

      CHARACTER*16 FORMATS_PS_GIF
      DIMENSION    FORMATS_PS_GIF(2)
      DATA         FORMATS_PS_GIF /'PS', 'GIF_ANIMATION'/

      CHARACTER*16 FORMATS_PS_GIF_PDF
      DIMENSION    FORMATS_PS_GIF_PDF(3)
      DATA         FORMATS_PS_GIF_PDF /'PS', 'GIF_ANIMATION', 'PDF'/

      CHARACTER*16 FORMATS_PS_GIF_SVG
      DIMENSION    FORMATS_PS_GIF_SVG(3)
      DATA         FORMATS_PS_GIF_SVG /'PS', 'GIF_ANIMATION', 'SVG'/

      CHARACTER*16 FORMATS_PS_PNG_SVG
      DIMENSION    FORMATS_PS_PNG_SVG(3)
      DATA         FORMATS_PS_PNG_SVG /'PS', 'PNG', 'SVG'/

      CHARACTER*16 FORMATS_PS_GIF_PNG_SVG
      DIMENSION    FORMATS_PS_GIF_PNG_SVG(4)
      DATA         FORMATS_PS_GIF_PNG_SVG /'PS', 'GIF_ANIMATION', 
     +                                     'PNG', 'SVG'/

      CHARACTER*16 FORMATS_ALL
      DIMENSION    FORMATS_ALL(5)
      DATA         FORMATS_ALL /'PS', 'SVG', 'PDF',
     +                          'KML', 'PNG'/

      INTEGER NUM_ARGS
      INTEGER DEVICE_SET

      DEVICE_SET = 0

      ID_TEXT = ''

      NUM_ARGS = IARGC()

      I = 1
C
C  Start GoTo
C
20    IF (I.LE.NUM_ARGS) THEN
          CALL GETARG ( I, ARG )
C
C         Set the projection?
C
          IF (ARG.EQ.'PROJECTION') THEN
              I = I + 1 
              CALL GETARG ( I, PROJECTION ) 
              CALL PSETC ('SUBPAGE_MAP_PROJECTION', PROJECTION)
C
C        Set the device?
C
          ELSEIF (ARG.EQ.'DEVICE') THEN
              I = I + 1 
              CALL GETARG ( I, DEVICE ) 

C             Set the output filename

              IF     (DEVICE.EQ.'PS')  THEN
                OUTNAME = OUTROOTNAME //   '.ps'
                CALL PSETC ('DEVICE',       DEVICE)
                CALL PSETC ('PS_DEVICE',   'ps_a4')
                CALL PSETC ('PS_FILE_NAME', OUTNAME)
              ELSEIF (DEVICE.EQ.'PS_NEW') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'PS')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'EPS') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'EPS')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'GIF') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'GIF_ANIMATION')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
                CALL PSETI ('OUTPUT_GIF_DELAY',     150)
              ELSEIF (DEVICE.EQ.'GIF_MULTI') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'GIF')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'PNG') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'PNG')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'JPEG') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'JPEG')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'SVG') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'SVG')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'CSVG') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'CSVG')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'KML') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'KML')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)

              ELSEIF (DEVICE.EQ.'BAD') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'BAD')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)

              ELSEIF (DEVICE.EQ.'PS_GIF') THEN
                CALL PSET1C ('OUTPUT_FORMATS', FORMATS_PS_GIF, 2)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'PS_GIF_PDF') THEN
                CALL PSET1C ('OUTPUT_FORMATS', FORMATS_PS_GIF_PDF, 3)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'PS_GIF_SVG') THEN
                CALL PSET1C ('OUTPUT_FORMATS', FORMATS_PS_GIF_SVG, 3)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'PS_PNG_SVG') THEN
                CALL PSET1C ('OUTPUT_FORMATS', FORMATS_PS_PNG_SVG, 3)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'PS_GIF_PNG_SVG') THEN
                CALL PSET1C ('OUTPUT_FORMATS',
     +                               FORMATS_PS_GIF_PNG_SVG, 4)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'ALL') THEN
                CALL PSET1C ('OUTPUT_FORMATS', FORMATS_ALL, 5)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSE
                WRITE(*, '(A)') 'BAD DEVICE: ', DEVICE
              ENDIF
            
            DEVICE_SET = 1
C
C        Split the PostScript pages into separate files?
C
          ELSEIF (ARG.EQ.'PS_SPLIT') THEN
                CALL PSETC ('OUTPUT_PS_SPLIT',     'ON')
C
C        Turn on the numbering for the first page?
C
          ELSEIF (ARG.EQ.'FIRST_PAGE_NUMBER') THEN
                CALL PSETC ('OUTPUT_NAME_FIRST_PAGE_NUMBER', 'ON')
C
C         Set the minimal filename number width?
C
          ELSEIF (ARG.EQ.'MINIMAL') THEN
              I = I + 1 
              CALL GETARG (I, MINIMAL) 
              IF     (MINIMAL.EQ.'0')  THEN
                CALL PSETI ('OUTPUT_FILE_MINIMAL_WIDTH', 0)
              ELSEIF (MINIMAL.EQ.'1')  THEN
                CALL PSETI ('OUTPUT_FILE_MINIMAL_WIDTH', 1)
              ELSEIF (MINIMAL.EQ.'2') THEN
                CALL PSETI ('OUTPUT_FILE_MINIMAL_WIDTH', 2)
              ELSEIF (MINIMAL.EQ.'3') THEN
                CALL PSETI ('OUTPUT_FILE_MINIMAL_WIDTH', 3)
              ENDIF
C
C         Set the file number separator?
C
          ELSEIF (ARG.EQ.'SEP') THEN
              I = I + 1 
              CALL GETARG ( I, SEPARATOR ) 
              CALL PSETC ('OUTPUT_FILE_SEPARATOR', SEPARATOR)
C
C        Run using linear contouring?
C
          ELSEIF (ARG.EQ.'LINEAR') THEN
                CALL PSETC ('CONTOUR_METHOD', 'LINEAR')
                CALL PSETC ('PAGE_ID_LINE_USER_TEXT_PLOT', 'ON')
                CALL PSETC ('PAGE_ID_LINE_USER_TEXT', 'LINEAR')
          ENDIF
          I = I + 1 
          GOTO 20
      ENDIF
C
C     If no device has been set, then use PostScript by default
C
      IF (DEVICE_SET.EQ.0) THEN
        OUTNAME = OUTROOTNAME // '.ps'
        CALL PSETC ('PS_DEVICE',    'ps_a4')
        CALL PSETC ('PS_FILE_NAME', OUTNAME)
      ENDIF
C
      END



