---
title: Using Jekyll with Bundler
author: mkasberg
date: 2018-03-06 21:33:25 -0700
---

> Bundler provides a consistent environment for Ruby projects by tracking and
> installing the exact gems and versions that are needed.

[Bundler](https://bundler.io) can be a great tool to use with Jekyll. Because it
tracks dependencies on a per-project basis, it is particularly useful if you
need to run different versions of Jekyll in different projects.

In addition, because it can (optionally) install dependencies in the project
folder, it can help you avoid permissions issues you might otherwise run into.
The usual way to use Jekyll is to install Jekyll to the system's default gem
installation directory and then run `jekyll new`. In this tutorial, we'll show
you how to create a new Jekyll project using Bundler and without installing gems
outside the project directory.

<div class="note info">
  <h5>This is not the simplest way to start using Jekyll</h5>
  <p>
    This tutorial helps you get Jekyll set up using Bundler, and optionally
    without any system-wide gem installations. If prefer installing the jekyll
    command to your default gem installation directory, you might want the
    <a href="{% link _docs/index.md %}">Quickstart</a>.
  </p>
</div>

## Before You Begin

To complete this tutorial, you'll need to have
[Ruby](https://www.ruby-lang.org/en/) and [Bundler](https://bundler.io/)
installed. You can find the installation instructions on their websites.

## Initialize Bundler

The first thing to do is create a new directory for your project and run
`bundle init`. This creates a new Bundler project (by creating an empty
Gemfile).

```sh
mkdir my-jekyll-website
cd my-jekyll-website
bundle init
```

## Configure Bundler Install Path

This step is optional. In this step, we're going to configure Bundler to install
gems in the `./vendor/bundle/` project subdirectory. The advantage of doing this
is that bundler will install gems within your project folder instead of the
location used by `gem install`. This can help you avoid permissions errors you
might otherwise get during gem installation, depending how you installed Ruby.
If you skip this step, Bundler will install your dependencies to the location
used by `gem install`.


```sh
bundle config set --local path 'vendor/bundle'
```

<div class="note info">
  <h5>Bundler Config is Persistent</h5>
  <p>
    This step is only required once per project. Bundler saves your config in
    <code>./.bundle/config</code>, so future gems will be installed to the same
    location.
  </p>
</div>

## Add Jekyll

Now, we're going to use Bundler to add Jekyll as a dependency of our new
project. This command will add the Jekyll gem to our Gemfile and install it to
the `./vendor/bundle/` folder (or your default gem installation directory if you
didn't set a custom path).

```sh
bundle add jekyll
```

## Create A Jekyll Scaffold

Now that Jekyll is installed, we can use it to create the scaffolding for our
site. We need the `--force` parameter because our folder isn't empty - it
already has some Bundler files in it. We run the `bundle install` separately
because Jekyll gets confused if the Gemfile already exists.

```sh
bundle exec jekyll new --force --skip-bundle .
bundle install
```

## Serve the Site

Your new website is ready! You can serve the website with
`bundle exec jekyll serve` and visit it at
[http://127.0.0.1:4000](http://127.0.0.1:4000). From here, you're ready to
continue developing the site on your own. All of the normal Jekyll commands are
available to you, but you should prefix them with `bundle exec` so that Bundler
runs the version of Jekyll that is installed in your project folder.

## Commit to Source Control

If you're storing your new site in version control, you'll want to ignore the
`./vendor/` and `./.bundle/` folders since they contain user- or
platform-specific information. New users will be able to install the correct
dependencies based on `Gemfile` and `Gemfile.lock`, which should both be checked
in. You can use this `.gitignore` to get started, if you want.

**.gitignore**

```
# Ignore metadata generated by Jekyll
_site/
.sass-cache/
.jekyll-cache/
.jekyll-metadata

# Ignore folders generated by Bundler
.bundle/
vendor/
```
