/*******************************************************************************
  Copyright (c) 2023-2024, Intel Corporation

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

      * Redistributions of source code must retain the above copyright notice,
        this list of conditions and the following disclaimer.
      * Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.
      * Neither the name of Intel Corporation nor the names of its contributors
        may be used to endorse or promote products derived from this software
        without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

/* ZUC-EEA3 128,  */
#include "cipher_test.h"

/**
 *  Note: ZUC IV params stored in vector IV field
 *  uin32_t count = iv[0-3]
 *  uint8_t bearer = iv[4]
 *  uint8_t direction = iv[5]
 */
const struct cipher_test zuc_eea3_128_test_json[] = {
        { 48, 128, 1, "\x17\x3d\x14\xba\x50\x03\x73\x1d\x7a\x60\x04\x94\x70\xf0\x0a\x29",
          "\x92\x54\x03\x66\x0f\x00",
          "\x6c\xf6\x53\x40\x73\x55\x52\xab\x0c\x97\x52\xfa\x6f\x90\x25\xfe\x0b\xd6\x75\xd9\x00\x58"
          "\x75\xb2\x00\x00\x00\x00",
          "\xa6\xc8\x5f\xc6\x6a\xfb\x85\x33\xaa\xfc\x25\x18\xdf\xe7\x84\x94\x0e\xe1\xe4\xb0\x30\x23"
          "\x8c\xc8\x00\x00\x00\x00",
          1, 193 },
        { 48, 128, 2, "\xe5\xbd\x3e\xa0\xeb\x55\xad\xe8\x66\xc6\xac\x58\xbd\x54\x30\x2a",
          "\x23\x68\x05\x00\x18\x01",
          "\x14\xa8\xef\x69\x3d\x67\x85\x07\xbb\xe7\x27\x0a\x7f\x67\xff\x50\x06\xc3\x52\x5b\x98\x07"
          "\xe4\x67\xc4\xe5\x60\x00\xba\x33\x8f\x5d\x42\x95\x59\x03\x67\x51\x82\x22\x46\xc8\x0d\x3b"
          "\x38\xf0\x7f\x4b\xe2\xd8\xff\x58\x05\xf5\x13\x22\x29\xbd\xe9\x3b\xbb\xdc\xaf\x38\x2b\xf1"
          "\xee\x97\x2f\xbf\x99\x77\xba\xda\x89\x45\x84\x7a\x2a\x6c\x9a\xd3\x4a\x66\x75\x54\xe0\x4d"
          "\x1f\x7f\xa2\xc3\x32\x41\xbd\x8f\x01\xba\x22\x0d",
          "\x13\x1d\x43\xe0\xde\xa1\xbe\x5c\x5a\x1b\xfd\x97\x1d\x85\x2c\xbf\x71\x2d\x7b\x4f\x57\x96"
          "\x1f\xea\x32\x08\xaf\xa8\xbc\xa4\x33\xf4\x56\xad\x09\xc7\x41\x7e\x58\xbc\x69\xcf\x88\x66"
          "\xd1\x35\x3f\x74\x86\x5e\x80\x78\x1d\x20\x2d\xfb\x3e\xcf\xf7\xfc\xbc\x3b\x19\x0f\xe8\x2a"
          "\x20\x4e\xd0\xe3\x50\xfc\x0f\x6f\x26\x13\xb2\xf2\xbc\xa6\xdf\x5a\x47\x3a\x57\xa4\xa0\x0d"
          "\x98\x5e\xba\xd8\x80\xd6\xf2\x38\x64\xa0\x7b\x01",
          1, 800 },
        { 48, 128, 3, "\xd4\x55\x2a\x8f\xd6\xe6\x1c\xc8\x1a\x20\x09\x14\x1a\x29\xc1\x0b",
          "\xC1\x2E\x45\x76\x02\x01",
          "\x38\xf0\x7f\x4b\xe2\xd8\xff\x58\x05\xf5\x13\x22\x29\xbd\xe9\x3b\xbb\xdc\xaf\x38\x2b\xf1"
          "\xee\x97\x2f\xbf\x99\x77\xba\xda\x89\x45\x84\x7a\x2a\x6c\x9a\xd3\x4a\x66\x75\x54\xe0\x4d"
          "\x1f\x7f\xa2\xc3\x32\x41\xbd\x8f\x01\xba\x22\x0d\x3c\xa4\xec\x41\xe0\x74\x59\x5f\x54\xae"
          "\x2b\x45\x4f\xd9\x71\x43\x20\x43\x60\x19\x65\xcc\xa8\x5c\x24\x17\xed\x6c\xbe\xc3\xba\xda"
          "\x84\xfc\x8a\x57\x9a\xea\x78\x37\xb0\x27\x11\x77\x24\x2a\x64\xdc\x0a\x9d\xe7\x1a\x8e\xde"
          "\xe8\x6c\xa3\xd4\x7d\x03\x3d\x6b\xf5\x39\x80\x4e\xca\x86\xc5\x84\xa9\x05\x2d\xe4\x6a\xd3"
          "\xfc\xed\x65\x54\x3b\xd9\x02\x07\x37\x2b\x27\xaf\xb7\x92\x34\xf5\xff\x43\xea\x87\x08\x20"
          "\xe2\xc2\xb7\x8a\x8a\xae\x61\xcc\xe5\x2a\x05\x15\xe3\x48\xd1\x96\x66\x4a\x34\x56\xb1\x82"
          "\xa0\x7c\x40\x6e\x4a\x20\x79\x12\x71\xcf\xed\xa1\x65\xd5\x35\xec\x5e\xa2\xd4\xdf\x40\x00"
          "\x00\x00",
          "\x83\x83\xb0\x22\x9f\xcc\x0b\x9d\x22\x95\xec\x41\xc9\x77\xe9\xc2\xbb\x72\xe2\x20\x37\x81"
          "\x41\xf9\xc8\x31\x8f\x3a\x27\x0d\xfb\xcd\xee\x64\x11\xc2\xb3\x04\x4f\x17\x6d\xc6\xe0\x0f"
          "\x89\x60\xf9\x7a\xfa\xcd\x13\x1a\xd6\xa3\xb4\x9b\x16\xb7\xba\xbc\xf2\xa5\x09\xeb\xb1\x6a"
          "\x75\xdc\xab\x14\xff\x27\x5d\xbe\xee\xa1\xa2\xb1\x55\xf9\xd5\x2c\x26\x45\x2d\x01\x87\xc3"
          "\x10\xa4\xee\x55\xbe\xaa\x78\xab\x40\x24\x61\x5b\xa9\xf5\xd5\xad\xc7\x72\x8f\x73\x56\x06"
          "\x71\xf0\x13\xe5\xe5\x50\x08\x5d\x32\x91\xdf\x7d\x5f\xec\xed\xde\xd5\x59\x64\x1b\x6c\x2f"
          "\x58\x52\x33\xbc\x71\xe9\x60\x2b\xd2\x30\x58\x55\xbb\xd2\x5f\xfa\x7f\x17\xec\xbc\x04\x2d"
          "\xaa\xe3\x8c\x1f\x57\xad\x8e\x8e\xbd\x37\x34\x6f\x71\xbe\xfd\xbb\x74\x32\xe0\xe0\xbb\x2c"
          "\xfc\x09\xbc\xd9\x65\x70\xcb\x0c\x0c\x39\xdf\x5e\x29\x29\x4e\x82\x70\x3a\x63\x7f\x80\x00"
          "\x00\x00",
          1, 1570 },
        { 48, 128, 4, "\xdb\x84\xb4\xfb\xcc\xda\x56\x3b\x66\x22\x7b\xfe\x45\x6f\x0f\x77",
          "\xE1\x0F\x85\xE4\x10\x01",
          "\xe5\x39\xf3\xb8\x97\x32\x40\xda\x03\xf2\xb8\xaa\x05\xee\x0a\x00\xdb\xaf\xc0\xe1\x82\x05"
          "\x5d\xfe\x3d\x73\x83\xd9\x2c\xef\x40\xe9\x29\x28\x60\x5d\x52\xd0\x5f\x4f\x90\x18\xa1\xf1"
          "\x89\xae\x39\x97\xce\x19\x15\x5f\xb1\x22\x1d\xb8\xbb\x09\x51\xa8\x53\xad\x85\x2c\xe1\x6c"
          "\xff\x07\x38\x2c\x93\xa1\x57\xde\x00\xdd\xb1\x25\xc7\x53\x9f\xd8\x50\x45\xe4\xee\x07\xe0"
          "\xc4\x3f\x9e\x9d\x6f\x41\x4f\xc4\xd1\xc6\x29\x17\x81\x3f\x74\xc0\x0f\xc8\x3f\x3e\x2e\xd7"
          "\xc4\x5b\xa5\x83\x52\x64\xb4\x3e\x0b\x20\xaf\xda\x6b\x30\x53\xbf\xb6\x42\x3b\x7f\xce\x25"
          "\x47\x9f\xf5\xf1\x39\xdd\x9b\x5b\x99\x55\x58\xe2\xa5\x6b\xe1\x8d\xd5\x81\xcd\x01\x7c\x73"
          "\x5e\x6f\x0d\x0d\x97\xc4\xdd\xc1\xd1\xda\x70\xc6\xdb\x4a\x12\xcc\x92\x77\x8e\x2f\xbb\xd6"
          "\xf3\xba\x52\xaf\x91\xc9\xc6\xb6\x4e\x8d\xa4\xf7\xa2\xc2\x66\xd0\x2d\x00\x17\x53\xdf\x08"
          "\x96\x03\x93\xc5\xd5\x68\x88\xbf\x49\xeb\x5c\x16\xd9\xa8\x04\x27\xa4\x16\xbc\xb5\x97\xdf"
          "\x5b\xfe\x6f\x13\x89\x0a\x07\xee\x13\x40\xe6\x47\x6b\x0d\x9a\xa8\xf8\x22\xab\x0f\xd1\xab"
          "\x0d\x20\x4f\x40\xb7\xce\x6f\x2e\x13\x6e\xb6\x74\x85\xe5\x07\x80\x4d\x50\x45\x88\xad\x37"
          "\xff\xd8\x16\x56\x8b\x2d\xc4\x03\x11\xdf\xb6\x54\xcd\xea\xd4\x7e\x23\x85\xc3\x43\x62\x03"
          "\xdd\x83\x6f\x9c\x64\xd9\x74\x62\xad\x5d\xfa\x63\xb5\xcf\xe0\x8a\xcb\x95\x32\x86\x6f\x5c"
          "\xa7\x87\x56\x6f\xca\x93\xe6\xb1\x69\x3e\xe1\x5c\xf6\xf7\xa2\xd6\x89\xd9\x74\x17\x98\xdc"
          "\x1c\x23\x8e\x1b\xe6\x50\x73\x3b\x18\xfb\x34\xff\x88\x0e\x16\xbb\xd2\x1b\x47\xac\x00"
          "\x00",
          "\x4b\xbf\xa9\x1b\xa2\x5d\x47\xdb\x9a\x9f\x19\x0d\x96\x2a\x19\xab\x32\x39\x26\xb3\x51\xfb"
          "\xd3\x9e\x35\x1e\x05\xda\x8b\x89\x25\xe3\x0b\x1c\xce\x0d\x12\x21\x10\x10\x95\x81\x5c\xc7"
          "\xcb\x63\x19\x50\x9e\xc0\xd6\x79\x40\x49\x19\x87\xe1\x3f\x0a\xff\xac\x33\x2a\xa6\xaa\x64"
          "\x62\x6d\x3e\x9a\x19\x17\x51\x9e\x0b\x97\xb6\x55\xc6\xa1\x65\xe4\x4c\xa9\xfe\xac\x07\x90"
          "\xd2\xa3\x21\xad\x3d\x86\xb7\x9c\x51\x38\x73\x9f\xa3\x8d\x88\x7e\xc7\xde\xf4\x49\xce\x8a"
          "\xbd\xd3\xe7\xf8\xdc\x4c\xa9\xe7\xb7\x33\x14\xad\x31\x0f\x90\x25\xe6\x19\x46\xb3\xa5\x6d"
          "\xc6\x49\xec\x0d\xa0\xd6\x39\x43\xdf\xf5\x92\xcf\x96\x2a\x7e\xfb\x2c\x85\x24\xe3\x5a\x2a"
          "\x6e\x78\x79\xd6\x26\x04\xef\x26\x86\x95\xfa\x40\x03\x02\x7e\x22\xe6\x08\x30\x77\x52\x20"
          "\x64\xbd\x4a\x5b\x90\x6b\x5f\x53\x12\x74\xf2\x35\xed\x50\x6c\xff\x01\x54\xc7\x54\x92\x8a"
          "\x0c\xe5\x47\x6f\x2c\xb1\x02\x0a\x12\x22\xd3\x2c\x14\x55\xec\xae\xf1\xe3\x68\xfb\x34\x4d"
          "\x17\x35\xbf\xbe\xde\xb7\x1d\x0a\x33\xa2\xa5\x4b\x1d\xa5\xa2\x94\xe6\x79\x14\x4d\xdf\x11"
          "\xeb\x1a\x3d\xe8\xcf\x0c\xc0\x61\x91\x79\x74\xf3\x5c\x1d\x9c\xa0\xac\x81\x80\x7f\x8f\xcc"
          "\xe6\x19\x9a\x6c\x77\x12\xda\x86\x50\x21\xb0\x4c\xe0\x43\x95\x16\xf1\xa5\x26\xcc\xda\x9f"
          "\xd9\xab\xbd\x53\xc3\xa6\x84\xf9\xae\x1e\x7e\xe6\xb1\x1d\xa1\x38\xea\x82\x6c\x55\x16\xb5"
          "\xaa\xdf\x1a\xbb\xe3\x6f\xa7\xff\xf9\x2e\x3a\x11\x76\x06\x4e\x8d\x95\xf2\xe4\x88\x2b\x55"
          "\x00\xb9\x32\x28\xb2\x19\x4a\x47\x5c\x1a\x27\xf6\x3f\x9f\xfd\x26\x49\x89\xa1\xbc\x00"
          "\x00",
          1, 2798 },
        { 48, 128, 5, "\xe1\x3f\xed\x21\xb4\x6e\x4e\x7e\xc3\x12\x53\xb2\xbb\x17\xb3\xe0",
          "\xAA\xCD\x38\x27\x1a\x00",
          "\x8d\x74\xe2\x0d\x54\x89\x4e\x06\xd3\xcb\x13\xcb\x39\x33\x06\x5e\x86\x74\xbe\x62\xad\xb1"
          "\xc7\x2b\x3a\x64\x69\x65\xab\x63\xcb\x7b\x78\x54\xdf\xdc\x27\xe8\x49\x29\xf4\x9c\x64\xb8"
          "\x72\xa4\x90\xb1\x3f\x95\x7b\x64\x82\x7e\x71\xf4\x1f\xbd\x42\x69\xa4\x2c\x97\xf8\x24\x53"
          "\x70\x27\xf8\x6e\x9f\x4a\xd8\x2d\x1d\xf4\x51\x69\x0f\xdd\x98\xb6\xd0\x3f\x3a\x0e\xbe\x3a"
          "\x31\x2d\x6b\x84\x0b\xa5\xa1\x82\x0b\x2a\x2c\x97\x09\xc0\x90\xd2\x45\xed\x26\x7c\xf8\x45"
          "\xae\x41\xfa\x97\x5d\x33\x33\xac\x30\x09\xfd\x40\xeb\xa9\xeb\x5b\x88\x57\x14\xb7\x68\xb6"
          "\x97\x13\x8b\xaf\x21\x38\x0e\xca\x49\xf6\x44\xd4\x86\x89\xe4\x21\x57\x60\xb9\x06\x73\x9f"
          "\x0d\x2b\x3f\x09\x11\x33\xca\x15\xd9\x81\xcb\xe4\x01\xba\xf7\x2d\x05\xac\xe0\x5c\xcc\xb2"
          "\xd2\x97\xf4\xef\x6a\x5f\x58\xd9\x12\x46\xcf\xa7\x72\x15\xb8\x92\xab\x44\x1d\x52\x78\x45"
          "\x27\x95\xcc\xb7\xf5\xd7\x90\x57\xa1\xc4\xf7\x7f\x80\xd4\x6d\xb2\x03\x3c\xb7\x9b\xed\xf8"
          "\xe6\x05\x51\xce\x10\xc6\x67\xf6\x2a\x97\xab\xaf\xab\xbc\xd6\x77\x20\x18\xdf\x96\xa2\x82"
          "\xea\x73\x7c\xe2\xcb\x33\x12\x11\xf6\x0d\x53\x54\xce\x78\xf9\x91\x8d\x9c\x20\x6c\xa0\x42"
          "\xc9\xb6\x23\x87\xdd\x70\x96\x04\xa5\x0a\xf1\x6d\x8d\x35\xa8\x90\x6b\xe4\x84\xcf\x2e\x74"
          "\xa9\x28\x99\x40\x36\x43\x53\x24\x9b\x27\xb4\xc9\xae\x29\xed\xdf\xc7\xda\x64\x18\x79\x1a"
          "\x4e\x7b\xaa\x06\x60\xfa\x64\x51\x1f\x2d\x68\x5c\xc3\xa5\xff\x70\xe0\xd2\xb7\x42\x92\xe3"
          "\xb8\xa0\xcd\x6b\x04\xb1\xc7\x90\xb8\xea\xd2\x70\x37\x08\x54\x0d\xea\x2f\xc0\x9c\x3d\xa7"
          "\x70\xf6\x54\x49\xe8\x4d\x81\x7a\x4f\x55\x10\x55\xe1\x9a\xb8\x50\x18\xa0\x02\x8b\x71\xa1"
          "\x44\xd9\x67\x91\xe9\xa3\x57\x79\x33\x50\x4e\xee\x00\x60\x34\x0c\x69\xd2\x74\xe1\xbf\x9d"
          "\x80\x5d\xcb\xcc\x1a\x6f\xaa\x97\x68\x00\xb6\xff\x2b\x67\x1d\xc4\x63\x65\x2f\xa8\xa3\x3e"
          "\xe5\x09\x74\xc1\xc2\x1b\xe0\x1e\xab\xb2\x16\x74\x30\x26\x9d\x72\xee\x51\x1c\x9d\xde\x30"
          "\x79\x7c\x9a\x25\xd8\x6c\xe7\x4f\x5b\x96\x1b\xe5\xfd\xfb\x68\x07\x81\x40\x39\xe7\x13\x76"
          "\x36\xbd\x1d\x7f\xa9\xe0\x9e\xfd\x20\x07\x50\x59\x06\xa5\xac\x45\xdf\xde\xed\x77\x57\xbb"
          "\xee\x74\x57\x49\xc2\x96\x33\x35\x0b\xee\x0e\xa6\xf4\x09\xdf\x45\x80\x16\x00\x00",
          "\x94\xea\xa4\xaa\x30\xa5\x71\x37\xdd\xf0\x9b\x97\xb2\x56\x18\xa2\x0a\x13\xe2\xf1\x0f\xa5"
          "\xbf\x81\x61\xa8\x79\xcc\x2a\xe7\x97\xa6\xb4\xcf\x2d\x9d\xf3\x1d\xeb\xb9\x90\x5c\xcf\xec"
          "\x97\xde\x60\x5d\x21\xc6\x1a\xb8\x53\x1b\x7f\x3c\x9d\xa5\xf0\x39\x31\xf8\xa0\x64\x2d\xe4"
          "\x82\x11\xf5\xf5\x2f\xfe\xa1\x0f\x39\x2a\x04\x76\x69\x98\x5d\xa4\x54\xa2\x8f\x08\x09\x61"
          "\xa6\xc2\xb6\x2d\xaa\x17\xf3\x3c\xd6\x0a\x49\x71\xf4\x8d\x2d\x90\x93\x94\xa5\x5f\x48\x11"
          "\x7a\xce\x43\xd7\x08\xe6\xb7\x7d\x3d\xc4\x6d\x8b\xc0\x17\xd4\xd1\xab\xb7\x7b\x74\x28\xc0"
          "\x42\xb0\x6f\x2f\x99\xd8\xd0\x7c\x98\x79\xd9\x96\x00\x12\x7a\x31\x98\x5f\x10\x99\xbb\xd7"
          "\xd6\xc1\x51\x9e\xde\x8f\x5e\xeb\x4a\x61\x0b\x34\x9a\xc0\x1e\xa2\x35\x06\x91\x75\x6b\xd1"
          "\x05\xc9\x74\xa5\x3e\xdd\xb3\x5d\x1d\x41\x00\xb0\x12\xe5\x22\xab\x41\xf4\xc5\xf2\xfd\xe7"
          "\x6b\x59\xcb\x8b\x96\xd8\x85\xcf\xe4\x08\x0d\x13\x28\xa0\xd6\x36\xcc\x0e\xdc\x05\x80\x0b"
          "\x76\xac\xca\x8f\xef\x67\x20\x84\xd1\xf5\x2a\x8b\xbd\x8e\x09\x93\x32\x09\x92\xc7\xff\xba"
          "\xe1\x7c\x40\x84\x41\xe0\xee\x88\x3f\xc8\xa8\xb0\x5e\x22\xf5\xff\x7f\x8d\x1b\x48\xc7\x4c"
          "\x46\x8c\x46\x7a\x02\x8f\x09\xfd\x7c\xe9\x11\x09\xa5\x70\xa2\xd5\xc4\xd5\xf4\xfa\x18\xc5"
          "\xdd\x3e\x45\x62\xaf\xe2\x4e\xf7\x71\x90\x1f\x59\xaf\x64\x58\x98\xac\xef\x08\x8a\xba\xe0"
          "\x7e\x92\xd5\x2e\xb2\xde\x55\x04\x5b\xb1\xb7\xc4\x16\x4e\xf2\xd7\xa6\xca\xc1\x5e\xeb\x92"
          "\x6d\x7e\xa2\xf0\x8b\x66\xe1\xf7\x59\xf3\xae\xe4\x46\x14\x72\x5a\xa3\xc7\x48\x2b\x30\x84"
          "\x4c\x14\x3f\xf8\x5b\x53\xf1\xe5\x83\xc5\x01\x25\x7d\xdd\xd0\x96\xb8\x12\x68\xda\xa3\x03"
          "\xf1\x72\x34\xc2\x33\x35\x41\xf0\xbb\x8e\x19\x06\x48\xc5\x80\x7c\x86\x6d\x71\x93\x22\x86"
          "\x09\xad\xb9\x48\x68\x6f\x7d\xe2\x94\xa8\x02\xcc\x38\xf7\xfe\x52\x08\xf5\xea\x31\x96\xd0"
          "\x16\x7b\x9b\xdd\x02\xf0\xd2\xa5\x22\x1c\xa5\x08\xf8\x93\xaf\x5c\x4b\x4b\xb9\xf4\xf5\x20"
          "\xfd\x84\x28\x9b\x3d\xbe\x7e\x61\x49\x7a\x7e\x2a\x58\x40\x37\xea\x63\x7b\x69\x81\x12\x71"
          "\x74\xaf\x57\xb4\x71\xdf\x4b\x27\x68\xfd\x79\xc1\x54\x0f\xb3\xed\xf2\xea\x22\xcb\x69\xbe"
          "\xc0\xcf\x8d\x93\x3d\x9c\x6f\xdd\x64\x5e\x85\x05\x91\xcc\xa3\xd6\x2c\x0c\xc0\x00",
          1, 4019 },
        /*
         * ZUC algorithm tests from 3GPP Document3: Implementator's Test Data.
         * Version 1.1 (4th Jan. 2011).
         */
        { 128, 128, 6, "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
          "\x00\x00\x00\x00\x00\x00\x00\x00", "\x27\xbe\xde\x74\x01\x80\x82\xda", 1, 64 },
        { 128, 128, 7, "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
          "\x00\x00\x00\x00\x00\x00\x00\x00", "\x06\x57\xcf\xa0\x70\x96\x39\x8b", 1, 64 },
        { 128, 128, 8, "\x3d\x4c\x4b\xe9\x6a\x82\xfd\xae\xb5\x8f\x64\x1d\xb1\x7b\x45\x5b",
          "\x84\x31\x9a\xa8\xde\x69\x15\xca\x1f\x6b\xda\x6b\xfb\xd8\xc7\x66",
          "\x00\x00\x00\x00\x00\x00\x00\x00", "\x14\xf1\xc2\x72\x32\x79\xc4\x19", 1, 64 },
        { 128, 128, 9, "\x4d\x32\x0b\xfa\xd4\xc2\x85\xbf\xd6\xb8\xbd\x00\xf3\x9d\x8b\x41",
          "\x52\x95\x9d\xab\xa0\xbf\x17\x6e\xce\x2d\xc3\x15\x04\x9e\xb5\x74",
          "\x00\x00\x00\x00\x00\x00\x00\x00", "\xed\x44\x00\xe7\x06\x33\xe5\xc5", 1, 64 },
        /*
         * Extra vector to test corner case of LFSR update
         */
        { 48, 128, 10, "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x4b\x72\x50\xcf\x00\x00",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00",
          "\xF5\x55\x33\x65\x01\x31\x2E\xD7\x72\x08\xC8\xFC\x30\xB5\xA4\x4A"
          "\x7d\x09\x7d\x6e\x74\x4e\x10\x40\x07\x5f\x47\x85\x12\x69\x99\xd5"
          "\x6e\xb2\x3b\x97\x2a",
          1, 37 * 8 },
        { 0, 0, 0, NULL, NULL, NULL, NULL, 0, 0 }
};
