// Copyright 2017 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v3.21.12
// source: kms_aead.proto

package kms_aead_go_proto

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type KmsAeadKeyFormat struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Required.
	// The location of a KMS key.
	// With Google Cloud KMS, valid values have this format:
	// gcp-kms://projects/*/locations/*/keyRings/*/cryptoKeys/*.
	// With AWS KMS, valid values have this format:
	// aws-kms://arn:aws:kms:<region>:<account-id>:key/<key-id>
	KeyUri        string `protobuf:"bytes,1,opt,name=key_uri,json=keyUri,proto3" json:"key_uri,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *KmsAeadKeyFormat) Reset() {
	*x = KmsAeadKeyFormat{}
	mi := &file_kms_aead_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KmsAeadKeyFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KmsAeadKeyFormat) ProtoMessage() {}

func (x *KmsAeadKeyFormat) ProtoReflect() protoreflect.Message {
	mi := &file_kms_aead_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KmsAeadKeyFormat.ProtoReflect.Descriptor instead.
func (*KmsAeadKeyFormat) Descriptor() ([]byte, []int) {
	return file_kms_aead_proto_rawDescGZIP(), []int{0}
}

func (x *KmsAeadKeyFormat) GetKeyUri() string {
	if x != nil {
		return x.KeyUri
	}
	return ""
}

// There is no actual key material in the key.
type KmsAeadKey struct {
	state   protoimpl.MessageState `protogen:"open.v1"`
	Version uint32                 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// The key format also contains the params.
	Params        *KmsAeadKeyFormat `protobuf:"bytes,2,opt,name=params,proto3" json:"params,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *KmsAeadKey) Reset() {
	*x = KmsAeadKey{}
	mi := &file_kms_aead_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KmsAeadKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KmsAeadKey) ProtoMessage() {}

func (x *KmsAeadKey) ProtoReflect() protoreflect.Message {
	mi := &file_kms_aead_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KmsAeadKey.ProtoReflect.Descriptor instead.
func (*KmsAeadKey) Descriptor() ([]byte, []int) {
	return file_kms_aead_proto_rawDescGZIP(), []int{1}
}

func (x *KmsAeadKey) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *KmsAeadKey) GetParams() *KmsAeadKeyFormat {
	if x != nil {
		return x.Params
	}
	return nil
}

var File_kms_aead_proto protoreflect.FileDescriptor

const file_kms_aead_proto_rawDesc = "" +
	"\n" +
	"\x0ekms_aead.proto\x12\x12google.crypto.tink\"+\n" +
	"\x10KmsAeadKeyFormat\x12\x17\n" +
	"\akey_uri\x18\x01 \x01(\tR\x06keyUri\"d\n" +
	"\n" +
	"KmsAeadKey\x12\x18\n" +
	"\aversion\x18\x01 \x01(\rR\aversion\x12<\n" +
	"\x06params\x18\x02 \x01(\v2$.google.crypto.tink.KmsAeadKeyFormatR\x06paramsB[\n" +
	"\x1ccom.google.crypto.tink.protoP\x01Z9github.com/tink-crypto/tink-go/v2/proto/kms_aead_go_protob\x06proto3"

var (
	file_kms_aead_proto_rawDescOnce sync.Once
	file_kms_aead_proto_rawDescData []byte
)

func file_kms_aead_proto_rawDescGZIP() []byte {
	file_kms_aead_proto_rawDescOnce.Do(func() {
		file_kms_aead_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_kms_aead_proto_rawDesc), len(file_kms_aead_proto_rawDesc)))
	})
	return file_kms_aead_proto_rawDescData
}

var file_kms_aead_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_kms_aead_proto_goTypes = []any{
	(*KmsAeadKeyFormat)(nil), // 0: google.crypto.tink.KmsAeadKeyFormat
	(*KmsAeadKey)(nil),       // 1: google.crypto.tink.KmsAeadKey
}
var file_kms_aead_proto_depIdxs = []int32{
	0, // 0: google.crypto.tink.KmsAeadKey.params:type_name -> google.crypto.tink.KmsAeadKeyFormat
	1, // [1:1] is the sub-list for method output_type
	1, // [1:1] is the sub-list for method input_type
	1, // [1:1] is the sub-list for extension type_name
	1, // [1:1] is the sub-list for extension extendee
	0, // [0:1] is the sub-list for field type_name
}

func init() { file_kms_aead_proto_init() }
func file_kms_aead_proto_init() {
	if File_kms_aead_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_kms_aead_proto_rawDesc), len(file_kms_aead_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_kms_aead_proto_goTypes,
		DependencyIndexes: file_kms_aead_proto_depIdxs,
		MessageInfos:      file_kms_aead_proto_msgTypes,
	}.Build()
	File_kms_aead_proto = out.File
	file_kms_aead_proto_goTypes = nil
	file_kms_aead_proto_depIdxs = nil
}
