//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/oep/armoep"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// EnergyServicesServer is a fake server for instances of the armoep.EnergyServicesClient type.
type EnergyServicesServer struct {
	// BeginAddPartition is the fake for method EnergyServicesClient.BeginAddPartition
	// HTTP status codes to indicate success: http.StatusCreated
	BeginAddPartition func(ctx context.Context, resourceGroupName string, resourceName string, options *armoep.EnergyServicesClientBeginAddPartitionOptions) (resp azfake.PollerResponder[armoep.EnergyServicesClientAddPartitionResponse], errResp azfake.ErrorResponder)

	// BeginCreate is the fake for method EnergyServicesClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, resourceGroupName string, resourceName string, options *armoep.EnergyServicesClientBeginCreateOptions) (resp azfake.PollerResponder[armoep.EnergyServicesClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method EnergyServicesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, resourceName string, options *armoep.EnergyServicesClientBeginDeleteOptions) (resp azfake.PollerResponder[armoep.EnergyServicesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method EnergyServicesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, resourceName string, options *armoep.EnergyServicesClientGetOptions) (resp azfake.Responder[armoep.EnergyServicesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByResourceGroupPager is the fake for method EnergyServicesClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armoep.EnergyServicesClientListByResourceGroupOptions) (resp azfake.PagerResponder[armoep.EnergyServicesClientListByResourceGroupResponse])

	// NewListBySubscriptionPager is the fake for method EnergyServicesClient.NewListBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionPager func(options *armoep.EnergyServicesClientListBySubscriptionOptions) (resp azfake.PagerResponder[armoep.EnergyServicesClientListBySubscriptionResponse])

	// ListPartitions is the fake for method EnergyServicesClient.ListPartitions
	// HTTP status codes to indicate success: http.StatusOK
	ListPartitions func(ctx context.Context, resourceGroupName string, resourceName string, options *armoep.EnergyServicesClientListPartitionsOptions) (resp azfake.Responder[armoep.EnergyServicesClientListPartitionsResponse], errResp azfake.ErrorResponder)

	// BeginRemovePartition is the fake for method EnergyServicesClient.BeginRemovePartition
	// HTTP status codes to indicate success: http.StatusCreated
	BeginRemovePartition func(ctx context.Context, resourceGroupName string, resourceName string, options *armoep.EnergyServicesClientBeginRemovePartitionOptions) (resp azfake.PollerResponder[armoep.EnergyServicesClientRemovePartitionResponse], errResp azfake.ErrorResponder)

	// Update is the fake for method EnergyServicesClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, resourceName string, options *armoep.EnergyServicesClientUpdateOptions) (resp azfake.Responder[armoep.EnergyServicesClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewEnergyServicesServerTransport creates a new instance of EnergyServicesServerTransport with the provided implementation.
// The returned EnergyServicesServerTransport instance is connected to an instance of armoep.EnergyServicesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewEnergyServicesServerTransport(srv *EnergyServicesServer) *EnergyServicesServerTransport {
	return &EnergyServicesServerTransport{
		srv:                         srv,
		beginAddPartition:           newTracker[azfake.PollerResponder[armoep.EnergyServicesClientAddPartitionResponse]](),
		beginCreate:                 newTracker[azfake.PollerResponder[armoep.EnergyServicesClientCreateResponse]](),
		beginDelete:                 newTracker[azfake.PollerResponder[armoep.EnergyServicesClientDeleteResponse]](),
		newListByResourceGroupPager: newTracker[azfake.PagerResponder[armoep.EnergyServicesClientListByResourceGroupResponse]](),
		newListBySubscriptionPager:  newTracker[azfake.PagerResponder[armoep.EnergyServicesClientListBySubscriptionResponse]](),
		beginRemovePartition:        newTracker[azfake.PollerResponder[armoep.EnergyServicesClientRemovePartitionResponse]](),
	}
}

// EnergyServicesServerTransport connects instances of armoep.EnergyServicesClient to instances of EnergyServicesServer.
// Don't use this type directly, use NewEnergyServicesServerTransport instead.
type EnergyServicesServerTransport struct {
	srv                         *EnergyServicesServer
	beginAddPartition           *tracker[azfake.PollerResponder[armoep.EnergyServicesClientAddPartitionResponse]]
	beginCreate                 *tracker[azfake.PollerResponder[armoep.EnergyServicesClientCreateResponse]]
	beginDelete                 *tracker[azfake.PollerResponder[armoep.EnergyServicesClientDeleteResponse]]
	newListByResourceGroupPager *tracker[azfake.PagerResponder[armoep.EnergyServicesClientListByResourceGroupResponse]]
	newListBySubscriptionPager  *tracker[azfake.PagerResponder[armoep.EnergyServicesClientListBySubscriptionResponse]]
	beginRemovePartition        *tracker[azfake.PollerResponder[armoep.EnergyServicesClientRemovePartitionResponse]]
}

// Do implements the policy.Transporter interface for EnergyServicesServerTransport.
func (e *EnergyServicesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "EnergyServicesClient.BeginAddPartition":
		resp, err = e.dispatchBeginAddPartition(req)
	case "EnergyServicesClient.BeginCreate":
		resp, err = e.dispatchBeginCreate(req)
	case "EnergyServicesClient.BeginDelete":
		resp, err = e.dispatchBeginDelete(req)
	case "EnergyServicesClient.Get":
		resp, err = e.dispatchGet(req)
	case "EnergyServicesClient.NewListByResourceGroupPager":
		resp, err = e.dispatchNewListByResourceGroupPager(req)
	case "EnergyServicesClient.NewListBySubscriptionPager":
		resp, err = e.dispatchNewListBySubscriptionPager(req)
	case "EnergyServicesClient.ListPartitions":
		resp, err = e.dispatchListPartitions(req)
	case "EnergyServicesClient.BeginRemovePartition":
		resp, err = e.dispatchBeginRemovePartition(req)
	case "EnergyServicesClient.Update":
		resp, err = e.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (e *EnergyServicesServerTransport) dispatchBeginAddPartition(req *http.Request) (*http.Response, error) {
	if e.srv.BeginAddPartition == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginAddPartition not implemented")}
	}
	beginAddPartition := e.beginAddPartition.get(req)
	if beginAddPartition == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OpenEnergyPlatform/energyServices/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/addPartition`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armoep.DataPartitionAddOrRemoveRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		var options *armoep.EnergyServicesClientBeginAddPartitionOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armoep.EnergyServicesClientBeginAddPartitionOptions{
				Body: &body,
			}
		}
		respr, errRespr := e.srv.BeginAddPartition(req.Context(), resourceGroupNameParam, resourceNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginAddPartition = &respr
		e.beginAddPartition.add(req, beginAddPartition)
	}

	resp, err := server.PollerResponderNext(beginAddPartition, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusCreated}, resp.StatusCode) {
		e.beginAddPartition.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginAddPartition) {
		e.beginAddPartition.remove(req)
	}

	return resp, nil
}

func (e *EnergyServicesServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if e.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := e.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OpenEnergyPlatform/energyServices/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armoep.EnergyService](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		var options *armoep.EnergyServicesClientBeginCreateOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armoep.EnergyServicesClientBeginCreateOptions{
				Body: &body,
			}
		}
		respr, errRespr := e.srv.BeginCreate(req.Context(), resourceGroupNameParam, resourceNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		e.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		e.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		e.beginCreate.remove(req)
	}

	return resp, nil
}

func (e *EnergyServicesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if e.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := e.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OpenEnergyPlatform/energyServices/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginDelete(req.Context(), resourceGroupNameParam, resourceNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		e.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		e.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		e.beginDelete.remove(req)
	}

	return resp, nil
}

func (e *EnergyServicesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if e.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OpenEnergyPlatform/energyServices/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.Get(req.Context(), resourceGroupNameParam, resourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).EnergyService, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *EnergyServicesServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := e.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OpenEnergyPlatform/energyServices`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := e.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		e.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armoep.EnergyServicesClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		e.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (e *EnergyServicesServerTransport) dispatchNewListBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionPager not implemented")}
	}
	newListBySubscriptionPager := e.newListBySubscriptionPager.get(req)
	if newListBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OpenEnergyPlatform/energyServices`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := e.srv.NewListBySubscriptionPager(nil)
		newListBySubscriptionPager = &resp
		e.newListBySubscriptionPager.add(req, newListBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionPager, req, func(page *armoep.EnergyServicesClientListBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionPager) {
		e.newListBySubscriptionPager.remove(req)
	}
	return resp, nil
}

func (e *EnergyServicesServerTransport) dispatchListPartitions(req *http.Request) (*http.Response, error) {
	if e.srv.ListPartitions == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListPartitions not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OpenEnergyPlatform/energyServices/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listPartitions`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.ListPartitions(req.Context(), resourceGroupNameParam, resourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DataPartitionsListResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *EnergyServicesServerTransport) dispatchBeginRemovePartition(req *http.Request) (*http.Response, error) {
	if e.srv.BeginRemovePartition == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRemovePartition not implemented")}
	}
	beginRemovePartition := e.beginRemovePartition.get(req)
	if beginRemovePartition == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OpenEnergyPlatform/energyServices/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/removePartition`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armoep.DataPartitionAddOrRemoveRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		var options *armoep.EnergyServicesClientBeginRemovePartitionOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armoep.EnergyServicesClientBeginRemovePartitionOptions{
				Body: &body,
			}
		}
		respr, errRespr := e.srv.BeginRemovePartition(req.Context(), resourceGroupNameParam, resourceNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRemovePartition = &respr
		e.beginRemovePartition.add(req, beginRemovePartition)
	}

	resp, err := server.PollerResponderNext(beginRemovePartition, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusCreated}, resp.StatusCode) {
		e.beginRemovePartition.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRemovePartition) {
		e.beginRemovePartition.remove(req)
	}

	return resp, nil
}

func (e *EnergyServicesServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if e.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OpenEnergyPlatform/energyServices/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armoep.EnergyResourceUpdate](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	var options *armoep.EnergyServicesClientUpdateOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armoep.EnergyServicesClientUpdateOptions{
			Body: &body,
		}
	}
	respr, errRespr := e.srv.Update(req.Context(), resourceGroupNameParam, resourceNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).EnergyService, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
