//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/automation/armautomation"
	"net/http"
	"net/url"
	"regexp"
)

// NodeCountInformationServer is a fake server for instances of the armautomation.NodeCountInformationClient type.
type NodeCountInformationServer struct {
	// Get is the fake for method NodeCountInformationClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, automationAccountName string, countType armautomation.CountType, options *armautomation.NodeCountInformationClientGetOptions) (resp azfake.Responder[armautomation.NodeCountInformationClientGetResponse], errResp azfake.ErrorResponder)
}

// NewNodeCountInformationServerTransport creates a new instance of NodeCountInformationServerTransport with the provided implementation.
// The returned NodeCountInformationServerTransport instance is connected to an instance of armautomation.NodeCountInformationClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewNodeCountInformationServerTransport(srv *NodeCountInformationServer) *NodeCountInformationServerTransport {
	return &NodeCountInformationServerTransport{srv: srv}
}

// NodeCountInformationServerTransport connects instances of armautomation.NodeCountInformationClient to instances of NodeCountInformationServer.
// Don't use this type directly, use NewNodeCountInformationServerTransport instead.
type NodeCountInformationServerTransport struct {
	srv *NodeCountInformationServer
}

// Do implements the policy.Transporter interface for NodeCountInformationServerTransport.
func (n *NodeCountInformationServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "NodeCountInformationClient.Get":
		resp, err = n.dispatchGet(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (n *NodeCountInformationServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if n.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/nodecounts/(?P<countType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
	if err != nil {
		return nil, err
	}
	countTypeParam, err := parseWithCast(matches[regex.SubexpIndex("countType")], func(v string) (armautomation.CountType, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armautomation.CountType(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := n.srv.Get(req.Context(), resourceGroupNameParam, automationAccountNameParam, countTypeParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).NodeCounts, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
