// Code generated by smithy-go-codegen DO NOT EDIT.

package apptest

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/apptest/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets a test suite.
func (c *Client) GetTestSuite(ctx context.Context, params *GetTestSuiteInput, optFns ...func(*Options)) (*GetTestSuiteOutput, error) {
	if params == nil {
		params = &GetTestSuiteInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetTestSuite", params, optFns, c.addOperationGetTestSuiteMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetTestSuiteOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetTestSuiteInput struct {

	// The ID of the test suite.
	//
	// This member is required.
	TestSuiteId *string

	// The version of the test suite.
	TestSuiteVersion *int32

	noSmithyDocumentSerde
}

type GetTestSuiteOutput struct {

	// The after steps of the test suite.
	//
	// This member is required.
	AfterSteps []types.Step

	// The before steps of the test suite.
	//
	// This member is required.
	BeforeSteps []types.Step

	// The creation time of the test suite.
	//
	// This member is required.
	CreationTime *time.Time

	// The last update time of the test suite.
	//
	// This member is required.
	LastUpdateTime *time.Time

	// The latest version of the test suite.
	//
	// This member is required.
	LatestVersion *types.TestSuiteLatestVersion

	// The name of the test suite.
	//
	// This member is required.
	Name *string

	// The test cases of the test suite.
	//
	// This member is required.
	TestCases types.TestCases

	// The test suite Amazon Resource Name (ARN).
	//
	// This member is required.
	TestSuiteArn *string

	// The response ID of the test suite.
	//
	// This member is required.
	TestSuiteId *string

	// The version of the test suite.
	//
	// This member is required.
	TestSuiteVersion *int32

	// The description of the test suite.
	Description *string

	// The status of the test suite.
	Status types.TestSuiteLifecycle

	// The status reason of the test suite.
	StatusReason *string

	// The tags of the test suite.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetTestSuiteMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetTestSuite{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetTestSuite{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetTestSuite"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetTestSuiteValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetTestSuite(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetTestSuite(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetTestSuite",
	}
}
