// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/connect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Searches routing profiles in an Amazon Connect instance, with optional
// filtering.
func (c *Client) SearchRoutingProfiles(ctx context.Context, params *SearchRoutingProfilesInput, optFns ...func(*Options)) (*SearchRoutingProfilesOutput, error) {
	if params == nil {
		params = &SearchRoutingProfilesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "SearchRoutingProfiles", params, optFns, c.addOperationSearchRoutingProfilesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*SearchRoutingProfilesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type SearchRoutingProfilesInput struct {

	// The identifier of the Amazon Connect instance. You can find the instance ID (https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
	// in the Amazon Resource Name (ARN) of the instance.
	//
	// This member is required.
	InstanceId *string

	// The maximum number of results to return per page.
	MaxResults *int32

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string

	// The search criteria to be used to return routing profiles. The name and
	// description fields support "contains" queries with a minimum of 2 characters and
	// a maximum of 25 characters. Any queries with character lengths outside of this
	// range will throw invalid results.
	SearchCriteria *types.RoutingProfileSearchCriteria

	// Filters to be applied to search results.
	SearchFilter *types.RoutingProfileSearchFilter

	noSmithyDocumentSerde
}

type SearchRoutingProfilesOutput struct {

	// The total number of routing profiles which matched your search query.
	ApproximateTotalCount *int64

	// If there are additional results, this is the token for the next set of results.
	NextToken *string

	// Information about the routing profiles.
	RoutingProfiles []types.RoutingProfile

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationSearchRoutingProfilesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpSearchRoutingProfiles{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpSearchRoutingProfiles{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "SearchRoutingProfiles"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpSearchRoutingProfilesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opSearchRoutingProfiles(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// SearchRoutingProfilesAPIClient is a client that implements the
// SearchRoutingProfiles operation.
type SearchRoutingProfilesAPIClient interface {
	SearchRoutingProfiles(context.Context, *SearchRoutingProfilesInput, ...func(*Options)) (*SearchRoutingProfilesOutput, error)
}

var _ SearchRoutingProfilesAPIClient = (*Client)(nil)

// SearchRoutingProfilesPaginatorOptions is the paginator options for
// SearchRoutingProfiles
type SearchRoutingProfilesPaginatorOptions struct {
	// The maximum number of results to return per page.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// SearchRoutingProfilesPaginator is a paginator for SearchRoutingProfiles
type SearchRoutingProfilesPaginator struct {
	options   SearchRoutingProfilesPaginatorOptions
	client    SearchRoutingProfilesAPIClient
	params    *SearchRoutingProfilesInput
	nextToken *string
	firstPage bool
}

// NewSearchRoutingProfilesPaginator returns a new SearchRoutingProfilesPaginator
func NewSearchRoutingProfilesPaginator(client SearchRoutingProfilesAPIClient, params *SearchRoutingProfilesInput, optFns ...func(*SearchRoutingProfilesPaginatorOptions)) *SearchRoutingProfilesPaginator {
	if params == nil {
		params = &SearchRoutingProfilesInput{}
	}

	options := SearchRoutingProfilesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &SearchRoutingProfilesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *SearchRoutingProfilesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next SearchRoutingProfiles page.
func (p *SearchRoutingProfilesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*SearchRoutingProfilesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.SearchRoutingProfiles(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opSearchRoutingProfiles(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "SearchRoutingProfiles",
	}
}
