gedit development - getting started
===================================

The following explanations can be improved over time, if you see something
missing, a feedback is welcome.

Programming languages and paradigms
-----------------------------------

gedit is mostly written in C, with some plugins in Python or
[Vala](https://wiki.gnome.org/Projects/Vala/). The
[Meson](https://mesonbuild.com/) build system is used.

The code is object-oriented and event-driven. In C, it's thanks to the use of
the GObject library (see next section). If you open some `*.c` or `*.h` files,
you may be frightened but – don't panic – it's just some C/GObject boilerplate
code, and that boilerplate can be generated by a tool. So once you've learned
GObject, you will no longer be afraid ;-)

Libraries used
--------------

As every GNOME application, gedit uses the GLib, GObject and GTK libraries. To
modify the gedit source code, you should be familiar with those libraries. See
the [GTK website](https://www.gtk.org/) and the document
[The GLib/GTK Development Platform – A Getting Started Guide](https://informatique-libre.be/swilmet/glib-gtk-book/).

The main widget used by gedit is GtkTextView, a general-purpose multiline text
editor. To learn that widget API, read the excellent
[GtkTextView tutorial](http://www.bravegnu.org/gtktext/) (a bit old but still
mostly valid). But GtkTextView is not enough for source code edition. gedit
actually uses the
[GtkSourceView](https://wiki.gnome.org/Projects/GtkSourceView) library, which
contains a subclass of GtkTextView with many features useful for a text editor
or an IDE. But GtkSourceView is not enough to have a full-blown text editor,
gedit is actually in the process of using more features from the
[Tepl](https://gitlab.gnome.org/swilmet/tepl) library, and to further develop
Tepl alongside gedit.

For its plugin system, gedit uses the
[libpeas](https://wiki.gnome.org/Projects/Libpeas) library.

Plugins may have other dependencies, for example the spell-checking plugin uses
[gspell](https://gitlab.gnome.org/GNOME/gspell).

gedit architecture
------------------

The [gedit Git repository](https://gitlab.gnome.org/GNOME/gedit) contains the
_gedit core_ plus the default plugins. There is also the
[gedit-plugins Git repository](https://gitlab.gnome.org/GNOME/gedit-plugins)
for additional official plugins. The gedit core source code is in the `gedit/`
directory. And as can be expected, the plugins are in …*drum roll*: `plugins/`!

gedit core provides:
- A basic text editor.
- The integration of libpeas, with an API for plugins.

There is a class diagram of gedit core in the file
[class-diagram.dia](class-diagram.dia) (but it may be outdated, see the Git log
for that file).

Build/Installation
------------------

See the file [build.md](build.md).

More information
----------------

See the [Newcomers](https://wiki.gnome.org/Newcomers/) page to start
contributing to GNOME in general. But perhaps some things explained there are
not relevant for gedit, in case of doubt the gedit documentation takes
precedence.

To know how to contribute to gedit specifically, read the
[CONTRIBUTING.md](../CONTRIBUTING.md) file.

A good way to learn a lot of things is to write a new plugin (as a third-party
plugin first).

A potentially easy task (but not always) is to fix compilation warnings, for
example when a deprecated function is used. If you encounter a runtime warning
or critical message, it is also a good idea to fix it.

Improvements to the documentation (for users or developers) is also useful,
especially to improve the API reference for developing gedit plugins.

Note that gedit, although simple to use, is old. Some parts of the code is
legacy code and would benefit from some refactoring. That's why writing plugins
is normally easier.

    Happy hacking,

    the gedit developers.
