{ -*- buffer-read-only: t -*-

  Copyright 2018-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated wrapper to make vectors/colors persistent.

  Do not edit this file manually!
  Instead
  - edit tools/internal/generate-persistent-vectors/persistent_vectors_input.txt
  - and run generate-persistent-vectors in that directory.
}

{$ifdef read_interface_class}
strict private
  FWorldAnchorPersistent: TCastleVector3Persistent;
  function GetWorldAnchorForPersistent: TVector3;
  procedure SetWorldAnchorForPersistent(const AValue: TVector3);
published
  { @link(WorldAnchor) that can be visually edited in
    Castle Game Engine Editor, Lazarus and Delphi.
    Normal user code does not need to deal with this,
    instead read or write @link(WorldAnchor) directly.

    @seealso WorldAnchor }
  property WorldAnchorPersistent: TCastleVector3Persistent read FWorldAnchorPersistent ;
{$endif read_interface_class}

{$ifdef read_implementation_methods}
function TCastleSliderJoint.GetWorldAnchorForPersistent: TVector3;
begin
  Result := WorldAnchor;
end;

procedure TCastleSliderJoint.SetWorldAnchorForPersistent(const AValue: TVector3);
begin
  WorldAnchor := AValue;
end;
{$endif read_implementation_methods}

{$ifdef read_implementation_constructor}
  FWorldAnchorPersistent := TCastleVector3Persistent.Create(nil);
  { Note that some classes (like TCastleVector3Persistent) call SetSubComponent(true)
    on themselves, for backward compatibility. But we should not depend on it,
    some classes (like TFloatRectanglePersisten) may not call it.
    The responsibility of calling "SetSubComponent(true)" should be on the owner
    in general (this is more functional, and more standard too). }
  FWorldAnchorPersistent.SetSubComponent(true);
  FWorldAnchorPersistent.InternalGetValue := {$ifdef FPC}@{$endif}GetWorldAnchorForPersistent;
  FWorldAnchorPersistent.InternalSetValue := {$ifdef FPC}@{$endif}SetWorldAnchorForPersistent;
  FWorldAnchorPersistent.InternalDefaultValue := WorldAnchor; // current value is default
{$endif read_implementation_constructor}

{$ifdef read_implementation_destructor}
  FreeAndNil(FWorldAnchorPersistent);
{$endif read_implementation_destructor}

{ -*- buffer-read-only: t -*-

  Copyright 2018-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated wrapper to make vectors/colors persistent.

  Do not edit this file manually!
  Instead
  - edit tools/internal/generate-persistent-vectors/persistent_vectors_input.txt
  - and run generate-persistent-vectors in that directory.
}

{$ifdef read_interface_class}
strict private
  FWorldSliderAxisPersistent: TCastleVector3Persistent;
  function GetWorldSliderAxisForPersistent: TVector3;
  procedure SetWorldSliderAxisForPersistent(const AValue: TVector3);
published
  { @link(WorldSliderAxis) that can be visually edited in
    Castle Game Engine Editor, Lazarus and Delphi.
    Normal user code does not need to deal with this,
    instead read or write @link(WorldSliderAxis) directly.

    @seealso WorldSliderAxis }
  property WorldSliderAxisPersistent: TCastleVector3Persistent read FWorldSliderAxisPersistent ;
{$endif read_interface_class}

{$ifdef read_implementation_methods}
function TCastleSliderJoint.GetWorldSliderAxisForPersistent: TVector3;
begin
  Result := WorldSliderAxis;
end;

procedure TCastleSliderJoint.SetWorldSliderAxisForPersistent(const AValue: TVector3);
begin
  WorldSliderAxis := AValue;
end;
{$endif read_implementation_methods}

{$ifdef read_implementation_constructor}
  FWorldSliderAxisPersistent := TCastleVector3Persistent.Create(nil);
  { Note that some classes (like TCastleVector3Persistent) call SetSubComponent(true)
    on themselves, for backward compatibility. But we should not depend on it,
    some classes (like TFloatRectanglePersisten) may not call it.
    The responsibility of calling "SetSubComponent(true)" should be on the owner
    in general (this is more functional, and more standard too). }
  FWorldSliderAxisPersistent.SetSubComponent(true);
  FWorldSliderAxisPersistent.InternalGetValue := {$ifdef FPC}@{$endif}GetWorldSliderAxisForPersistent;
  FWorldSliderAxisPersistent.InternalSetValue := {$ifdef FPC}@{$endif}SetWorldSliderAxisForPersistent;
  FWorldSliderAxisPersistent.InternalDefaultValue := WorldSliderAxis; // current value is default
{$endif read_implementation_constructor}

{$ifdef read_implementation_destructor}
  FreeAndNil(FWorldSliderAxisPersistent);
{$endif read_implementation_destructor}

