{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;
    class function ForVRMLVersion(const Version: TX3DVersion): Boolean; override;

    strict private FFdValue: TSFEnum;
    { Internal wrapper for property @code(Value). This wrapper API may change, we advise to access simpler @code(Value) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdValue: TSFEnum read FFdValue;

{$endif read_interface}

{$ifdef read_implementation}

{ TNormalBindingNode_1 ----------------------------------------------- }

class function TNormalBindingNode_1.ForVRMLVersion(const Version: TX3DVersion): Boolean;
begin
  Result := Version.Major <= 1; // parse this node only in VRML 1.0 and Inventor files
end;

class function TNormalBindingNode_1.ClassX3DType: String;
begin
  Result := 'NormalBinding';
end;

procedure TNormalBindingNode_1.CreateNode;
begin
  inherited;

  FFdValue := TSFEnum.Create(Self, True, 'value', @BindingNames1, Ord(High(BindingNames1)) + 1, BIND_DEFAULT);
   FdValue.ChangeAlways := chVisibleVRML1State;
  AddField(FFdValue);
end;

{$endif read_implementation}
